/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.unload_screw;

import com.spin.core.program_node.unload_screw.UnloadScrewData;
import com.spin.core.program_node.unload_screw.UnloadScrewText;
import com.spin.domain.ScrewFeeder;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UnloadScrewScriptGenerator {
    @NotNull
    private static InputStream variableDeclarationsScript() {
        return Objects.requireNonNull(UnloadScrewScriptGenerator.class.getResourceAsStream("variable_declarations.script"));
    }

    @NotNull
    private static InputStream safeApproachScript() {
        return Objects.requireNonNull(UnloadScrewScriptGenerator.class.getResourceAsStream("safe_approach.script"));
    }

    @NotNull
    private static InputStream directApproachScript() {
        return Objects.requireNonNull(UnloadScrewScriptGenerator.class.getResourceAsStream("direct_approach.script"));
    }

    @NotNull
    private static InputStream unloadScrewScript() {
        return Objects.requireNonNull(UnloadScrewScriptGenerator.class.getResourceAsStream("unload_screw.script"));
    }

    @NotNull
    private static InputStream departScript() {
        return Objects.requireNonNull(UnloadScrewScriptGenerator.class.getResourceAsStream("depart.script"));
    }

    void generateScript(@NotNull ScriptWriter scriptWriter, @NotNull TextResource textResource, @NotNull UnloadScrewData data) {
        ScrewFeeder feeder = Objects.requireNonNull(data.selectedScrewFeeder());
        Length screwLength = feeder.screwLength();
        Pose unloadPose = Objects.requireNonNull(data.getPose());
        String errorMessage = ScriptUtil.wrapInQuotes(textResource.load(UnloadScrewText.ERROR_MESSAGE));
        String errorTitle = ScriptUtil.wrapInQuotes(textResource.load(UnloadScrewText.ERROR_TITLE));
        ScriptParser parser = new ScriptParser(scriptWriter);
        parser.parseToScript(UnloadScrewScriptGenerator.variableDeclarationsScript(), ScriptUtil.toScript(unloadPose), Double.toString(screwLength.getAs(Length.Unit.MM)), errorMessage, errorTitle);
        parser.parseToScript(data.approachEnabled() ? UnloadScrewScriptGenerator.safeApproachScript() : UnloadScrewScriptGenerator.directApproachScript(), new String[0]);
        parser.parseToScript(UnloadScrewScriptGenerator.unloadScrewScript(), new String[0]);
        if (data.departEnabled()) {
            parser.parseToScript(UnloadScrewScriptGenerator.departScript(), new String[0]);
        }
    }
}

