/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw.pick_screw;

import com.spin.core.program_node.load_screw.pick_screw.PickScrewContribution;
import com.spin.core.program_node.load_screw.pick_screw.PickScrewText;
import com.spin.ui.callback.OnOkCallback;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.inputfield.InputField;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class PickScrewView
implements SwingProgramNodeView<PickScrewContribution> {
    @NotNull
    private final ImagePanel logo;
    @NotNull
    private final String pickScrewText;
    @NotNull
    private final InputField<Integer> motorSpeedRPM;
    @NotNull
    private final Label motorSpeedText;
    @NotNull
    private final Label motorSpeedUnit;
    @NotNull
    private final InputField<Integer> robotSpeedmms;
    @NotNull
    private final Label robotSpeedText;
    @NotNull
    private final Label robotSpeedUnit;
    @NotNull
    private final InputField<Double> waitTimeS;
    @NotNull
    private final Label waitTimeText;
    @NotNull
    private final Label waitTimeUnit;
    @NotNull
    private final UnitType unitType;

    PickScrewView(ExtendedViewAPIProvider viewAPIProvider) {
        TextResource textResource = viewAPIProvider.getTextResource();
        this.unitType = viewAPIProvider.getViewAPIProvider().getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        this.motorSpeedRPM = new InputField(InputField.Alignment.NUMBER);
        this.motorSpeedText = new Label(textResource.load(PickScrewText.MOTOR_SPEED_TEXT));
        this.motorSpeedUnit = new Label("RPM");
        this.robotSpeedmms = new InputField(InputField.Alignment.NUMBER);
        this.robotSpeedText = new Label(textResource.load(PickScrewText.ROBOT_SPEED_TEXT));
        this.robotSpeedUnit = new Label("mm/s");
        this.waitTimeS = new InputField(InputField.Alignment.NUMBER);
        this.waitTimeText = new Label(textResource.load(PickScrewText.WAIT_TIME_TEXT));
        this.waitTimeUnit = new Label("sec");
        this.logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        this.pickScrewText = textResource.load(PickScrewText.TEXT);
    }

    public void buildUI(JPanel panel, ContributionProvider<PickScrewContribution> contributionProvider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[top][]push[]"));
        panel.add((Component)new JLabel(this.pickScrewText), "cell 0 0 12 1");
        panel.add((Component)this.buildInputPanel(), "cell 0 1 12 1");
        panel.add((Component)this.logo, "cell 0 2 3 1");
        this.registerListeners(contributionProvider);
    }

    private JPanel buildInputPanel() {
        JPanel inputPanel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[][][]"));
        inputPanel.add((Component)this.motorSpeedText, "cell 0 0");
        inputPanel.add((Component)this.motorSpeedRPM.getTextField(), "cell 1 0 2 1, grow");
        inputPanel.add((Component)this.motorSpeedUnit, "cell 3 0");
        inputPanel.add((Component)this.robotSpeedText, "cell 0 1");
        inputPanel.add((Component)this.robotSpeedmms.getTextField(), "cell 1 1 2 1, grow");
        inputPanel.add((Component)this.robotSpeedUnit, "cell 3 1");
        inputPanel.add((Component)this.waitTimeText, "cell 0 2");
        inputPanel.add((Component)this.waitTimeS.getTextField(), "cell 1 2 2 1, grow");
        inputPanel.add((Component)this.waitTimeUnit, "cell 3 2");
        return inputPanel;
    }

    private void registerListeners(@NotNull ContributionProvider<PickScrewContribution> provider) {
        this.motorSpeedRPM.getTextField().addSimpleClickListener(() -> this.showMotorSpeedKeypad((PickScrewContribution)provider.get()));
        this.robotSpeedmms.getTextField().addSimpleClickListener(() -> this.showRobotSpeedKeypad((PickScrewContribution)provider.get()));
        this.waitTimeS.getTextField().addSimpleClickListener(() -> this.showWaitTimeKeypad((PickScrewContribution)provider.get()));
    }

    private void showMotorSpeedKeypad(@NotNull PickScrewContribution contribution) {
        Integer initialValue = this.motorSpeedRPM.getValue();
        KeyboardNumberInput<Integer> keypad = contribution.getMotorSpeedIntergerKeypad(initialValue);
        keypad.show((JTextField)this.motorSpeedRPM.getTextField(), new OnOkCallback<Integer>(speed -> this.setMotorSpeedRPM((int)speed, contribution)));
    }

    private void showRobotSpeedKeypad(@NotNull PickScrewContribution contribution) {
        Integer initialValue = this.robotSpeedmms.getValue();
        KeyboardNumberInput<Integer> keypad = contribution.getRobotSpeedIntergerKeypad(initialValue);
        keypad.show((JTextField)this.robotSpeedmms.getTextField(), new OnOkCallback<Integer>(speed -> this.setRobotSpeedmms((int)speed, contribution)));
    }

    private void showWaitTimeKeypad(@NotNull PickScrewContribution contribution) {
        Double initialValue = this.waitTimeS.getValue();
        KeyboardNumberInput<Double> keypad = contribution.getWaitTimeDoubleKeypad(initialValue);
        keypad.show((JTextField)this.waitTimeS.getTextField(), new OnOkCallback<Double>(time -> this.setWaitTimeS((double)time, contribution)));
    }

    public void setMotorSpeedField(int motorSpeed) {
        this.motorSpeedRPM.setValue(motorSpeed);
    }

    private void setMotorSpeedRPM(@NotNull int motorSpeed, @NotNull PickScrewContribution contribution) {
        this.motorSpeedRPM.setValue(motorSpeed);
        contribution.setMotorSpeedRPM(motorSpeed);
    }

    public void setRobotSpeedField(int robotSpeed) {
        this.robotSpeedmms.setValue(robotSpeed);
    }

    private void setRobotSpeedmms(int robotSpeed, @NotNull PickScrewContribution contribution) {
        this.robotSpeedmms.setValue(robotSpeed);
        contribution.setRobotSpeedmms(robotSpeed);
    }

    public void setWaitTimeField(double waitTime) {
        this.waitTimeS.setValue(waitTime);
    }

    private void setWaitTimeS(double waitTime, @NotNull PickScrewContribution contribution) {
        this.waitTimeS.setValue(waitTime);
        contribution.setWaitTimesec(waitTime);
    }
}

