/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bit_changing_station;

import com.spin.core.installation_node.bit_changing_station.BitChangingStationContribution;
import com.spin.core.installation_node.bit_changing_station.BitChangingStationText;
import com.spin.domain.BitChangingStation;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class StationDetailsView {
    @NotNull
    private final JComboBox<BitChangingStation> stationSelector;
    @NotNull
    private final JButton editButton;
    @NotNull
    private final JButton deleteButton;
    @NotNull
    private final JButton verifyPositionButton;
    @NotNull
    private final JButton addNewBitStationButton;
    @NotNull
    private Set<BitChangingStation> stations = Collections.emptySet();

    StationDetailsView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        ImageIcon deleteIcon = UR_Icon.DELETE.load();
        ImageIcon editIcon = UR_Icon.EDIT.load();
        ImageIcon wizardIcon = UR_Icon.WIZARD.load();
        ImageIcon addIcon = UR_Icon.PLUS.load();
        this.stationSelector = new ComboBox<BitChangingStation>();
        this.verifyPositionButton = new ButtonMedium(textResource.load(BitChangingStationText.VERIFY_POSITION), wizardIcon);
        this.editButton = new ButtonMedium(editIcon);
        this.deleteButton = new ButtonMedium(deleteIcon);
        ButtonMedium button = new ButtonMedium(textResource.load(BitChangingStationText.ADD_NEW_BIT_STATION), addIcon);
        button.enableCallToActionStyle(true);
        this.addNewBitStationButton = button;
    }

    @NotNull
    JPanel createLeftPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(6, 20, "50[]10[]50[]push[]100"));
        panel.add(this.stationSelector, "cell 1 0, span 4, grow");
        panel.add((Component)this.verifyPositionButton, "cell 1 1, span 4, grow");
        panel.add((Component)this.editButton, "cell 1 2, span 2, grow");
        panel.add((Component)this.deleteButton, "cell 3 2, span 2, grow");
        panel.add((Component)this.addNewBitStationButton, "cell 1 3, span 4, grow");
        return panel;
    }

    @NotNull
    JPanel createRightPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.singleColumn(20, "[grow]"));
        Dimension imageSize = new Dimension(500, -1);
        ImagePanel imagePanel = new ImagePanel(SpinImage.BIT_CHANGING_STATION.load(imageSize));
        panel.add((Component)imagePanel, "right");
        return panel;
    }

    void registerListeners(@NotNull BitChangingStationContribution contribution) {
        this.verifyPositionButton.addActionListener(event -> this.showVerifyPositionWizard(contribution));
        this.editButton.addActionListener(event -> this.showEditStationWizard(contribution));
        this.deleteButton.addActionListener(event -> this.deleteSelectedStation(contribution));
        this.addNewBitStationButton.addActionListener(event -> this.showAddNewStationWizard(contribution));
    }

    void setStations(@NotNull Set<BitChangingStation> stations) {
        this.stations = stations;
        this.stationSelector.removeAllItems();
        stations.stream().sorted(Comparator.comparing(station -> station.name().toLowerCase()).thenComparing(BitChangingStation::name)).forEach(this.stationSelector::addItem);
        this.enableComponents(!stations.isEmpty());
    }

    void selectStationByID(@NotNull UUID id) {
        BitChangingStation stationToSelect = this.stations.stream().filter(station -> station.id().equals(id)).findFirst().orElse(null);
        assert (stationToSelect != null);
        this.stationSelector.setSelectedItem(stationToSelect);
    }

    private void enableComponents(boolean enable) {
        Stream.of(this.editButton, this.deleteButton, this.verifyPositionButton, this.stationSelector).forEach(component -> component.setEnabled(enable));
    }

    private void deleteSelectedStation(@NotNull BitChangingStationContribution contribution) {
        BitChangingStation selectedStation = (BitChangingStation)this.stationSelector.getSelectedItem();
        assert (selectedStation != null);
        contribution.removeStation(selectedStation);
    }

    private void showVerifyPositionWizard(@NotNull BitChangingStationContribution contribution) {
        BitChangingStation selectedStation = (BitChangingStation)this.stationSelector.getSelectedItem();
        assert (selectedStation != null);
        contribution.onVerifyPositionFromDetailsView(selectedStation.poseAbovePointB(), selectedStation.poseOfPointB());
    }

    private void showEditStationWizard(@NotNull BitChangingStationContribution contribution) {
        BitChangingStation selectedStation = (BitChangingStation)this.stationSelector.getSelectedItem();
        assert (selectedStation != null);
        contribution.onEditExistingStation(selectedStation);
    }

    private void showAddNewStationWizard(@NotNull BitChangingStationContribution contribution) {
        contribution.onAddNewStation();
    }
}

