/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.approach;

import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.urcap.api.domain.variable.VariableModel;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class ApproachData {
    @NotNull
    private final DataModel model;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final SimpleValueFactory simpleValueFactory;
    @NotNull
    private final VariableModel variableModel;

    ApproachData(@NotNull DataModel model, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.model = model;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.simpleValueFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getSimpleValueFactory();
        this.variableModel = apiProvider.getProgramAPIProvider().getProgramAPI().getVariableModel();
    }

    @NotNull
    public Variable screwProgramStartPoseVariable() {
        return this.findExistingScrewProgramStartPoseVariable().orElseGet(this::createScrewProgramStartPoseVariable);
    }

    @NotNull
    private Optional<Variable> findExistingScrewProgramStartPoseVariable() {
        return this.variableModel.get(variable -> variable.getDisplayName().equals("program_start_p")).stream().findFirst();
    }

    @NotNull
    private Variable createScrewProgramStartPoseVariable() {
        try {
            return this.variableModel.getVariableFactory().createGlobalVariable("program_start_p");
        }
        catch (VariableException e) {
            SpinLog.print("Unable to create program_start_p variable");
            throw new RuntimeException(e);
        }
    }
}

