/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.toolbar.internal;

import com.spin.core.toolbar.internal.AlignedRenderer;
import com.spin.core.toolbar.internal.ResultTableModel;
import com.spin.ui.urstyle.UR_Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultTable<ResultType> {
    @NotNull
    private final DefaultTableModel model;
    @NotNull
    private final JTable table;
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final Function<ResultType, Object[]> resultToRowDataConversion;
    @NotNull
    private final List<ResultType> results = new ArrayList<ResultType>();

    public ResultTable(int rowCount, @NotNull Function<ResultType, Object[]> resultToRowDataConversion, Column ... columns) {
        this.model = new ResultTableModel(rowCount, columns);
        this.table = new JTable(this.model);
        this.scrollPane = new JScrollPane(this.table);
        this.resultToRowDataConversion = resultToRowDataConversion;
        this.setPreferredColumnWidths(columns);
        this.configureStyle();
    }

    private void setPreferredColumnWidths(@NotNull Column[] columns) {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columns.length; ++i) {
            Integer preferredWidth = columns[i].preferredWidth;
            if (preferredWidth == null) continue;
            columnModel.getColumn(i).setPreferredWidth(preferredWidth);
        }
    }

    private void configureStyle() {
        this.table.setDefaultRenderer(Object.class, new AlignedRenderer(0));
        this.table.setDefaultRenderer(String.class, new AlignedRenderer(2));
        this.scrollPane.getViewport().setBackground(UR_Color.WHITE);
        this.table.setBorder(BorderFactory.createLineBorder(UR_Color.UR_BLUE, 1));
        this.table.setRowHeight(30);
    }

    @NotNull
    public JComponent getViewComponent() {
        return this.scrollPane;
    }

    public void addNewResult(@NotNull ResultType result) {
        int numRows = this.model.getRowCount();
        this.model.insertRow(0, this.resultToRowDataConversion.apply(result));
        this.model.removeRow(numRows);
        this.results.add(0, result);
        if (this.results.size() > numRows) {
            this.results.remove(numRows);
        }
    }

    public void addResultClickListener(final @NotNull ResultClickListener<ResultType> listener) {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent event) {
                Point clickedPoint = event.getPoint();
                int row = ResultTable.this.table.rowAtPoint(clickedPoint);
                int column = ResultTable.this.table.columnAtPoint(clickedPoint);
                if (column != -1 && row != -1 && row < ResultTable.this.results.size()) {
                    listener.resultClicked(ResultTable.this.results.get(row));
                }
            }
        });
    }

    public static class Column {
        @NotNull
        final String name;
        @NotNull
        final Class<?> clazz;
        @Nullable
        final Integer preferredWidth;

        public Column(@NotNull String name) {
            this(name, Object.class, null);
        }

        public Column(@NotNull String name, @Nullable Integer preferredWidth) {
            this(name, Object.class, preferredWidth);
        }

        public Column(@NotNull String name, @NotNull Class<?> clazz) {
            this(name, clazz, null);
        }

        public Column(@NotNull String name, @NotNull Class<?> clazz, @Nullable Integer preferredWidth) {
            this.name = name;
            this.clazz = clazz;
            this.preferredWidth = preferredWidth;
        }
    }

    public static interface ResultClickListener<ResultType> {
        public void resultClicked(@NotNull ResultType var1);
    }
}

