/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component;

import com.spin.ui.component.SimpleMouseListener;
import com.spin.ui.urstyle.UR_Color;
import java.awt.Dimension;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class TextField
extends JTextField {
    private boolean inputIsValid = true;

    public TextField() {
        this(null, null, 0);
    }

    public TextField(String text) {
        this(null, text, 0);
    }

    public TextField(int columns) {
        this(null, null, columns);
    }

    public TextField(String text, int columns) {
        this(null, text, columns);
    }

    public TextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.setEditable(false);
        this.setURHeight();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateBackground();
    }

    public boolean inputIsValid() {
        return this.inputIsValid;
    }

    public void setInputValid(boolean valid) {
        this.inputIsValid = valid;
        this.updateBackground();
    }

    public void addSimpleClickListener(@NotNull SimpleClickListener listener) {
        this.addMouseListener(new SimpleMouseListener(listener));
    }

    private void updateBackground() {
        if (this.isEnabled() && !this.inputIsValid) {
            this.setBackground(UR_Color.LIGHT_YELLOW);
        } else {
            this.setBackground(UR_Color.WHITE);
        }
    }

    private void setURHeight() {
        Dimension preferredSize = super.getPreferredSize();
        Dimension maximumSize = super.getMaximumSize();
        preferredSize.height = 30;
        maximumSize.height = Integer.MAX_VALUE;
        maximumSize.width = Integer.MAX_VALUE;
        super.setPreferredSize(preferredSize);
        super.setMaximumSize(maximumSize);
    }

    public static interface SimpleClickListener {
        public void onClick();
    }
}

