/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_not_OK;

import com.spin.core.program_node.screwdriving_setup.on_not_OK.OnNotOkData;
import com.spin.core.program_node.screwdriving_setup.on_not_OK.OnNotOkText;
import com.spin.core.program_node.screwdriving_setup.on_not_OK.OnNotOkView;
import com.spin.domain.MultiInstall;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.api.NodeFactory;
import com.spin.util.i18n.TextResource;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.variable.Variable;
import org.jetbrains.annotations.NotNull;

public class OnNotOkContribution
implements ProgramNodeContribution {
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final OnNotOkView view;
    @NotNull
    private final OnNotOkData data;

    OnNotOkContribution(@NotNull OnNotOkView view, @NotNull OnNotOkData data, @NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType nodeCreationType) {
        this.view = view;
        this.data = data;
        this.textResource = apiProvider.getTextResource();
        if (nodeCreationType == CreationContext.NodeCreationType.NEW) {
            OnNotOkContribution.buildSubTree(apiProvider, this, this.textResource);
        }
    }

    private static void buildSubTree(@NotNull ExtendedProgramAPIProvider apiProvider, @NotNull OnNotOkContribution contribution, @NotNull TextResource textResource) {
        Expression spin_result_evaluation;
        TreeNode rootNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getRootTreeNode((ProgramNodeContribution)contribution);
        ProgramNodeFactory programNodeFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory();
        SimpleValueFactory valueFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getSimpleValueFactory();
        Variable spin_message = NodeFactory.get_spin_message(apiProvider.getProgramAPIProvider().getProgramAPI());
        ExpressionBuilder expressionBuilder = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        try {
            spin_result_evaluation = expressionBuilder.append(MultiInstall.urscriptPrefix() + "program_messages()").build();
        }
        catch (Exception e) {
            SpinLog.print("Cannot create expression: " + e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            if (MultiInstall.isMultiInstall()) {
                NodeFactory.addAbortFlagAssignmentNode(apiProvider.getProgramAPIProvider().getProgramAPI(), rootNode, programNodeFactory);
            }
            NodeFactory.addMoveAwayNode(rootNode, programNodeFactory, valueFactory);
            NodeFactory.addSafetyShieldCoverBitNode(rootNode, programNodeFactory);
            NodeFactory.addAssignmentNode(rootNode, programNodeFactory, spin_message, spin_result_evaluation);
            NodeFactory.addCommentNode(rootNode, programNodeFactory, textResource.load(OnNotOkText.HANDLE_ERROR_TEXT));
            NodeFactory.addHaltNode(rootNode, programNodeFactory);
        }
        catch (TreeStructureException | InvalidExpressionException e) {
            SpinLog.print("Cannot add child nodes to onNotOK node: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void openView() {
        this.view.setProgramErrorBlocks(this.data.getProgramErrorBlocks());
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(OnNotOkText.ON_NOT_OK);
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        writer.appendLine("elif (" + MultiInstall.urscriptPrefix() + "result_evaluation == 1):");
        writer.appendLine("  sync()");
        writer.writeChildren();
    }

    public void setProgramErrorBlocks(boolean enabled) {
        this.data.setProgramErrorBlocks(enabled);
    }
}

