/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.detach_bit;

import com.spin.core.program_node.detach_bit.DetachBitContribution;
import com.spin.core.program_node.detach_bit.DetachBitText;
import com.spin.domain.BitChangingStation;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.CheckBox;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.component.RadioButton;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetachBitView
implements SwingProgramNodeView<DetachBitContribution> {
    @NotNull
    private final ImagePanel logo;
    @NotNull
    private final ComboBox<BitChangingStation> bitStationSelector;
    @NotNull
    private final RadioButton bit1Selector;
    @NotNull
    private final RadioButton bit2Selector;
    @NotNull
    private final RadioButton bit3Selector;
    @NotNull
    private final Label setupMissingLabel;
    @NotNull
    private final ImagePanel bitStationImage;
    @NotNull
    private final ImageIcon bitStationBlank;
    @NotNull
    private final ImageIcon bitStationBit1;
    @NotNull
    private final ImageIcon bitStationBit2;
    @NotNull
    private final ImageIcon bitStationBit3;
    @NotNull
    private final JPanel bitSelectorPanel;
    @NotNull
    private final CheckBox approachCheckBox;
    @NotNull
    private final MessageBoxSmall approachWarning;
    @NotNull
    private final JPanel approachAndDeparturePanel;
    @NotNull
    private final Map<BitChangingStation.Bit, Runnable> bitSelectionFunctions = new HashMap<BitChangingStation.Bit, Runnable>();
    @Nullable
    private BitChangingStation.Bit selectedBit = null;
    @Nullable
    private ActionListener comboBoxListener;

    public DetachBitView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        this.logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        this.bitStationSelector = new ComboBox();
        this.bitStationSelector.setDefaultText(textResource.load(DetachBitText.NONE));
        this.bit1Selector = new RadioButton();
        this.bit2Selector = new RadioButton();
        this.bit3Selector = new RadioButton();
        this.setupMissingLabel = new Label(textResource.load(DetachBitText.MISSING_SETUP), UR_Icon.WARNING_SMALL.load(), 2);
        Dimension dimension = new Dimension(-1, 180);
        this.bitStationBlank = SpinImage.BIT_CHANGING_STATION.load(dimension);
        this.bitStationBit1 = SpinImage.BIT_CHANGING_STATION_BIT_1.load(dimension);
        this.bitStationBit2 = SpinImage.BIT_CHANGING_STATION_BIT_2.load(dimension);
        this.bitStationBit3 = SpinImage.BIT_CHANGING_STATION_BIT_3.load(dimension);
        this.bitStationImage = new ImagePanel(this.bitStationBlank);
        ButtonGroup bitSelectors = new ButtonGroup();
        bitSelectors.add(this.bit2Selector);
        bitSelectors.add(this.bit3Selector);
        bitSelectors.add(this.bit1Selector);
        this.bitSelectionFunctions.put(null, () -> {
            bitSelectors.clearSelection();
            this.bitStationImage.setIcon(this.bitStationBlank);
        });
        this.bitSelectionFunctions.put(BitChangingStation.Bit.BIT_1, () -> {
            this.bit1Selector.setSelected(true);
            this.bitStationImage.setIcon(this.bitStationBit1);
        });
        this.bitSelectionFunctions.put(BitChangingStation.Bit.BIT_2, () -> {
            this.bit2Selector.setSelected(true);
            this.bitStationImage.setIcon(this.bitStationBit2);
        });
        this.bitSelectionFunctions.put(BitChangingStation.Bit.BIT_3, () -> {
            this.bit3Selector.setSelected(true);
            this.bitStationImage.setIcon(this.bitStationBit3);
        });
        this.bitSelectorPanel = new JPanel((LayoutManager)new MigLayout("", "[grow]12[]67[]68[][grow]", "[][][]push"));
        this.bitSelectorPanel.add((Component)this.bitStationImage, "cell 0 0, span 5, grow");
        this.bitSelectorPanel.add((Component)this.bit1Selector, "cell 1 1");
        this.bitSelectorPanel.add((Component)this.bit2Selector, "cell 2 1");
        this.bitSelectorPanel.add((Component)this.bit3Selector, "cell 3 1");
        this.approachCheckBox = new CheckBox(textResource.load(DetachBitText.APPROACH_ENABLE));
        this.approachWarning = new MessageBoxSmall(textResource.load(DetachBitText.APPROACH_WARNING), AbstractMessageBox.Type.WARNING);
        this.approachAndDeparturePanel = new JPanel();
        this.approachAndDeparturePanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[][]"));
        this.approachAndDeparturePanel.add((Component)this.approachCheckBox, "cell 0 0");
        this.approachAndDeparturePanel.add((Component)this.approachWarning, "cell 0 1, span 12, left, hidemode 3");
    }

    public void buildUI(@NotNull JPanel panel, @NotNull ContributionProvider<DetachBitContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[top][][][]push[][][][]push[]"));
        panel.add(this.bitStationSelector, "cell 0 0, span 7, grow");
        panel.add((Component)this.bitSelectorPanel, "cell 0 2, span 7 2, hidemode 3");
        panel.add((Component)this.setupMissingLabel, "cell 0 2, span 5, gaptop 10, hidemode 3");
        panel.add((Component)this.approachAndDeparturePanel, "cell 0 4, span 12 2, growx, hidemode 3");
        panel.add((Component)this.logo, "cell 0 8, span 4 2");
        this.registerListeners(provider);
        this.show_bitStation_image_for(null);
    }

    private void registerListeners(@NotNull ContributionProvider<DetachBitContribution> provider) {
        this.comboBoxListener = e -> {
            BitChangingStation newSelectedStation = (BitChangingStation)this.bitStationSelector.getSelectedItem();
            if (newSelectedStation != null) {
                ((DetachBitContribution)provider.get()).selectStation(newSelectedStation);
                this.setPanelVisibility(false);
            }
        };
        this.bitStationSelector.addActionListener(this.comboBoxListener);
        Consumer<BitChangingStation.Bit> updateSelectionIfChanged = bit -> {
            if (this.selectedBit != bit) {
                ((DetachBitContribution)provider.get()).selectBit((BitChangingStation.Bit)((Object)bit));
                this.show_bitStation_image_for((BitChangingStation.Bit)((Object)bit));
            }
            this.selectedBit = bit;
        };
        this.bit1Selector.addActionListener(event -> updateSelectionIfChanged.accept(BitChangingStation.Bit.BIT_1));
        this.bit2Selector.addActionListener(event -> updateSelectionIfChanged.accept(BitChangingStation.Bit.BIT_2));
        this.bit3Selector.addActionListener(event -> updateSelectionIfChanged.accept(BitChangingStation.Bit.BIT_3));
        this.approachCheckBox.addActionListener(event -> {
            boolean enabled = this.approachCheckBox.isSelected();
            ((DetachBitContribution)provider.get()).setApproachEnabled(enabled);
            this.approachWarning.setVisible(!enabled);
        });
    }

    void setSelectedBit(@Nullable BitChangingStation.Bit bit) {
        this.selectedBit = bit;
        this.bitSelectionFunctions.get((Object)bit).run();
    }

    void setSelectedStation(@Nullable BitChangingStation bitChangingStation) {
        this.bitStationSelector.setSelectedItem(bitChangingStation);
        this.setPanelVisibility(bitChangingStation == null);
    }

    void setApproachEnabled(boolean enabled) {
        this.approachCheckBox.setSelected(enabled);
        this.approachWarning.setVisible(!enabled);
    }

    void setStations(@NotNull Set<BitChangingStation> stations) {
        this.bitStationSelector.removeActionListener(this.comboBoxListener);
        this.bitStationSelector.removeAllItems();
        stations.stream().sorted(Comparator.comparing(station -> station.name().toLowerCase()).thenComparing(BitChangingStation::name)).forEach(this.bitStationSelector::addItem);
        this.bitStationSelector.addActionListener(this.comboBoxListener);
        this.setupMissingLabel.setVisible(stations.isEmpty());
    }

    void setPanelVisibility(boolean visible) {
        this.bitSelectorPanel.setVisible(!visible);
        this.approachAndDeparturePanel.setVisible(!visible);
    }

    void show_bitStation_image_for(@Nullable BitChangingStation.Bit bit) {
        if (bit == null) {
            this.bitStationImage.setIcon(this.bitStationBlank);
        }
        if (bit == BitChangingStation.Bit.BIT_1) {
            this.bitStationImage.setIcon(this.bitStationBit1);
        }
        if (bit == BitChangingStation.Bit.BIT_2) {
            this.bitStationImage.setIcon(this.bitStationBit2);
        }
        if (bit == BitChangingStation.Bit.BIT_3) {
            this.bitStationImage.setIcon(this.bitStationBit3);
        }
    }
}

