/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.screw_feeder;

import com.spin.core.installation_node.screw_feeder.ScrewFeederContribution;
import com.spin.core.installation_node.screw_feeder.ScrewFeederText;
import com.spin.ui.callback.OnMovementCompleteCallback;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VerifyFeederPositionView {
    @NotNull
    private final JButton moveAboveScrewButton;
    @NotNull
    private final JButton moveToScrewButton;
    @NotNull
    private final JButton cancelButton;
    @Nullable
    private Pose aboveScrewPose = null;
    @Nullable
    private Pose atScrewPose = null;

    VerifyFeederPositionView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        ImageIcon moveIcon = UR_Icon.MOVE.load();
        ImageIcon cancelIcon = UR_Icon.CANCEL.load();
        this.moveAboveScrewButton = new ButtonMedium(textResource.load(ScrewFeederText.MOVE_ABOVE_SCREW), moveIcon);
        this.moveToScrewButton = new ButtonMedium(textResource.load(ScrewFeederText.MOVE_TO_SCREW), moveIcon);
        this.cancelButton = new ButtonMedium(textResource.load(ScrewFeederText.CANCEL), cancelIcon);
    }

    @NotNull
    JPanel createPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(6, 20, "push[]10[]push[]push"));
        panel.add((Component)this.moveAboveScrewButton, "cell 1 0, span 4, grow");
        panel.add((Component)this.moveToScrewButton, "cell 1 1, span 4, grow");
        panel.add((Component)this.cancelButton, "cell 2 2, span 2, grow");
        return panel;
    }

    void registerListeners(@NotNull ScrewFeederContribution contribution) {
        this.moveAboveScrewButton.addActionListener(event -> this.moveAboveScrew(contribution));
        this.moveToScrewButton.addActionListener(event -> this.moveToScrew(contribution));
        this.cancelButton.addActionListener(event -> contribution.onExitVerifyPosition());
    }

    void resetWithPoses(@NotNull Pose aboveScrewPose, @NotNull Pose atScrewPose) {
        this.aboveScrewPose = aboveScrewPose;
        this.atScrewPose = atScrewPose;
        this.moveToScrewButton.setEnabled(false);
    }

    private void moveAboveScrew(@NotNull ScrewFeederContribution contribution) {
        assert (this.aboveScrewPose != null);
        RobotMovement robotMovement = contribution.getUserInteraction().getRobotMovement();
        robotMovement.requestUserToMoveRobot(this.aboveScrewPose, (RobotMovementCallback)new OnMovementCompleteCallback(() -> this.moveToScrewButton.setEnabled(true)));
    }

    private void moveToScrew(@NotNull ScrewFeederContribution contribution) {
        assert (this.atScrewPose != null);
        RobotMovement robotMovement = contribution.getUserInteraction().getRobotMovement();
        robotMovement.requestUserToMoveRobot(this.atScrewPose, (RobotMovementCallback)new OnMovementCompleteCallback(contribution::onExitVerifyPosition));
    }
}

