/*
 * Decompiled with CFR 0.152.
 */
package com.spin.domain;

import com.spin.domain.SerialNumber;
import com.spin.domain.SpinSoftwareVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BridgeInfo {
    @NotNull
    private final SerialNumber serialNumber;
    @NotNull
    private final SpinSoftwareVersion softwareVersion;
    @Nullable
    private final SpinSoftwareVersion minURCapsVersion;
    @Nullable
    private Boolean isURCapVersionSupported;
    @Nullable
    private Boolean isBridgeSoftwareVersionSupported;

    public BridgeInfo(@NotNull SerialNumber serialNumber, @NotNull SpinSoftwareVersion softwareVersion) {
        this.serialNumber = serialNumber;
        this.softwareVersion = softwareVersion;
        this.minURCapsVersion = null;
        this.isURCapVersionSupported = null;
        this.isBridgeSoftwareVersionSupported = null;
    }

    public BridgeInfo(@NotNull SerialNumber serialNumber, @NotNull SpinSoftwareVersion softwareVersion, @NotNull SpinSoftwareVersion minURCapsVersion) {
        this.serialNumber = serialNumber;
        this.softwareVersion = softwareVersion;
        this.minURCapsVersion = minURCapsVersion;
        this.isURCapVersionSupported = null;
        this.isBridgeSoftwareVersionSupported = null;
    }

    public void setURCapVersion(@NotNull SpinSoftwareVersion URCap_version) {
        this.isURCapVersionSupported = URCap_version.isAtLeast(this.minURCapsVersion);
    }

    @Nullable
    public Boolean isURCapVersionSupported() {
        return this.isURCapVersionSupported;
    }

    public void setMinBridgeSoftwareVersion(@NotNull SpinSoftwareVersion minBridgeSoftwareVersion) {
        this.isBridgeSoftwareVersionSupported = this.softwareVersion.isAtLeast(minBridgeSoftwareVersion);
    }

    @Nullable
    public Boolean isBridgeSoftwareVersionSupported() {
        return this.isBridgeSoftwareVersionSupported;
    }

    @NotNull
    public SerialNumber serialNumber() {
        return this.serialNumber;
    }

    @NotNull
    public SpinSoftwareVersion softwareVersion() {
        return this.softwareVersion;
    }

    @Nullable
    public SpinSoftwareVersion minURCapsVersion() {
        return this.minURCapsVersion;
    }
}

