/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.attach_bit;

import com.spin.core.program_node.attach_bit.AttachBitData;
import com.spin.core.program_node.attach_bit.AttachBitScriptGenerator;
import com.spin.core.program_node.attach_bit.AttachBitText;
import com.spin.core.program_node.attach_bit.AttachBitView;
import com.spin.domain.BitChangingStation;
import com.spin.domain.MultiInstall;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AttachBitContribution
implements ProgramNodeContribution {
    private static final Map<BitChangingStation.Bit, String> bitPostfixes = new HashMap<BitChangingStation.Bit, String>(){
        {
            this.put(BitChangingStation.Bit.BIT_1, " 1");
            this.put(BitChangingStation.Bit.BIT_2, " 2");
            this.put(BitChangingStation.Bit.BIT_3, " 3");
        }
    };
    @NotNull
    private final AttachBitView view;
    @NotNull
    private final AttachBitData data;
    @NotNull
    private final AttachBitScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;

    AttachBitContribution(@NotNull AttachBitView view, @NotNull AttachBitData data, @NotNull AttachBitScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = view;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
    }

    public void openView() {
        this.view.setStations(this.data.bitChangingStations());
        this.view.setSelectedBit(this.data.selectedBit());
        this.view.setApproachEnabled(this.data.approachEnabled());
        this.view.setDepartEnabled(this.data.departEnabled());
        this.view.setSelectedStation(this.data.selectedStation());
    }

    public void closeView() {
    }

    @NotNull
    public String getTitle() {
        String title = MultiInstall.prefix() + this.textResource.load(AttachBitText.ATTACH_BIT);
        return title + bitPostfixes.getOrDefault((Object)this.data.selectedBit(), "");
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
    }

    void selectBit(@NotNull BitChangingStation.Bit bit) {
        this.data.setSelectedBit(bit);
    }

    void selectStation(@NotNull BitChangingStation station) {
        this.data.setSelectedStation(station);
    }

    void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    void setDepartEnabled(boolean enabled) {
        this.data.setDepartEnabled(enabled);
    }
}

