/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.move_to_screw;

import com.spin.core.program_node.move_to_screw.MoveToScrewContribution;
import com.spin.core.program_node.move_to_screw.MoveToScrewText;
import com.spin.core.program_node.move_to_screw.MoveToScrewVerifyPositionView;
import com.spin.ui.callback.OnOkPositionCallback;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.CheckBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MoveToScrewView
implements SwingProgramNodeView<MoveToScrewContribution> {
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final JPanel verifyPositionPanel;
    @NotNull
    private final CheckBox approachCheckBox;
    @NotNull
    private final MessageBoxSmall approachWarning;
    @NotNull
    private final ButtonMedium teachPositionButton;
    @NotNull
    private final ButtonMedium verifyPositionButton;
    @NotNull
    private final String teachPositionText;
    @NotNull
    private final String reteachPositionText;
    @NotNull
    private final MoveToScrewVerifyPositionView verifyPositionView;

    public MoveToScrewView(ExtendedViewAPIProvider extendedViewAPIProvider) {
        TextResource textResource = extendedViewAPIProvider.getTextResource();
        ImagePanel logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        this.approachCheckBox = new CheckBox(textResource.load(MoveToScrewText.APPROACH_ENABLE));
        this.approachWarning = new MessageBoxSmall(textResource.load(MoveToScrewText.APPROACH_WARNING), AbstractMessageBox.Type.WARNING);
        this.teachPositionText = textResource.load(MoveToScrewText.TEACH_POSITION);
        this.reteachPositionText = textResource.load(MoveToScrewText.RETEACH_POSITION);
        this.teachPositionButton = new ButtonMedium(this.teachPositionText, UR_Icon.MOVE_TEACH.load());
        this.verifyPositionButton = new ButtonMedium(textResource.load(MoveToScrewText.VERIFY_POSITION), UR_Icon.WIZARD.load());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "push[][][][]push[]"));
        this.mainPanel.add((Component)this.teachPositionButton, "cell 0 0, span 6, grow");
        this.mainPanel.add((Component)this.verifyPositionButton, "cell 0 1, span 6, grow");
        this.mainPanel.add((Component)this.approachCheckBox, "cell 0 2, span 12, grow");
        this.mainPanel.add((Component)this.approachWarning, "cell 0 3, span 12, left, hidemode 3");
        this.mainPanel.add((Component)logo, "cell 0 4, span 4");
        this.verifyPositionView = new MoveToScrewVerifyPositionView(extendedViewAPIProvider);
        this.verifyPositionPanel = this.verifyPositionView.createPanel();
        this.verifyPositionPanel.setVisible(false);
        this.setButtonStyleAsTeach();
    }

    public void buildUI(JPanel panel, ContributionProvider<MoveToScrewContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.singleColumn(10, "[grow]"));
        panel.add((Component)this.mainPanel, "cell 0 0, grow, hidemode 3");
        panel.add((Component)this.verifyPositionPanel, "cell 0 0, grow, hidemode 3");
        this.registerListeners(provider);
    }

    private void registerListeners(ContributionProvider<MoveToScrewContribution> provider) {
        this.approachCheckBox.addActionListener(event -> {
            boolean enabled = this.approachCheckBox.isSelected();
            ((MoveToScrewContribution)provider.get()).setApproachEnabled(enabled);
            this.approachWarning.setVisible(!enabled);
        });
        this.teachPositionButton.addActionListener(event -> this.getUserDefinedPosition((MoveToScrewContribution)provider.get()));
        this.verifyPositionButton.addActionListener(event -> {
            this.toggleActivePanel();
            this.verifyPositionView.resetWithPoses(((MoveToScrewContribution)provider.get()).poseAbove(), ((MoveToScrewContribution)provider.get()).pose());
        });
        this.verifyPositionView.registerListeners(provider);
    }

    public void toggleActivePanel() {
        this.mainPanel.setVisible(!this.mainPanel.isVisible());
        this.verifyPositionPanel.setVisible(!this.verifyPositionPanel.isVisible());
    }

    void setButtonStyleAsTeach() {
        this.teachPositionButton.enableCallToActionStyle(true);
        this.teachPositionButton.setText(this.teachPositionText);
    }

    void setButtonStyleAsReTeach() {
        this.teachPositionButton.enableCallToActionStyle(false);
        this.teachPositionButton.setText(this.reteachPositionText);
    }

    void verifyPositionButtonEnabled(boolean enabled) {
        this.verifyPositionButton.setEnabled(enabled);
    }

    void setApproachEnabled(boolean enabled) {
        this.approachCheckBox.setSelected(enabled);
        this.approachWarning.setVisible(!enabled);
    }

    private void getUserDefinedPosition(@NotNull MoveToScrewContribution contribution) {
        contribution.getUserInteraction().getUserDefinedRobotPosition((RobotPositionCallback2)new OnOkPositionCallback(parameters -> {
            contribution.setPose(parameters.getPose());
            this.setButtonStyleAsReTeach();
            this.verifyPositionButton.setEnabled(true);
        }));
    }
}

