/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.help;

import com.spin.core.installation_node.help.HelpContribution;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.LabelMainHeading;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class HelpView
implements SwingInstallationNodeView<HelpContribution> {
    @NotNull
    private final ImagePanel logo = new ImagePanel(SpinIcon.LOGO_INSTALLATION_NODE.load());

    public HelpView(@NotNull ExtendedViewAPIProvider apiProvider) {
    }

    public void buildUI(JPanel panel, HelpContribution contribution) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 20, "[]push[center]push"));
        panel.add((Component)this.logo, "cell 9 0, span 3, right");
        JPanel qrCodePanel = new JPanel();
        qrCodePanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(3, 20, "[][][]"));
        Integer size = 300;
        LabelMainHeading URCapBox = new LabelMainHeading("URCap");
        LabelMainHeading DashboardBox = new LabelMainHeading("Dashboard");
        LabelMainHeading SDSeriesBox = new LabelMainHeading("SD Series");
        MessageBoxSmall pluginMessageBox = new MessageBoxSmall("docs.plugins.ur.spin-robotics.com", AbstractMessageBox.Type.INFO);
        MessageBoxSmall dashboardMessageBox = new MessageBoxSmall("docs.dashboard.spin-robotics.com", AbstractMessageBox.Type.INFO);
        MessageBoxSmall sdseriesMessageBox = new MessageBoxSmall("docs.sdseries.spin-robotics.com", AbstractMessageBox.Type.INFO);
        qrCodePanel.add((Component)URCapBox, "cell 0 0, center");
        qrCodePanel.add((Component)DashboardBox, "cell 1 0, center");
        qrCodePanel.add((Component)SDSeriesBox, "cell 2 0, center");
        qrCodePanel.add((Component)new ImagePanel(SpinImage.PLUGIN_UR_QR_CODE.load(new Dimension(size, size))), "cell 0 1, center");
        qrCodePanel.add((Component)new ImagePanel(SpinImage.DASHBOARD_QR_CODE.load(new Dimension(size, size))), "cell 1 1, center");
        qrCodePanel.add((Component)new ImagePanel(SpinImage.SDSERIES_QR_CODE.load(new Dimension(size, size))), "cell 2 1, center");
        qrCodePanel.add((Component)pluginMessageBox, "cell 0 2, center");
        qrCodePanel.add((Component)dashboardMessageBox, "cell 1 2, center");
        qrCodePanel.add((Component)sdseriesMessageBox, "cell 2 2, center");
        panel.add((Component)qrCodePanel, "cell 0 1, span 12, center");
    }
}

