/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component;

import com.spin.ui.urstyle.UR_Color;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMessageBox
extends JLabel {
    public AbstractMessageBox(@Nullable String text, @NotNull Type type) {
        super(text, null, 0);
        this.setMessageStyle(type);
    }

    public AbstractMessageBox(@NotNull Type type) {
        this(null, type);
    }

    private void setMessageStyle(@NotNull Type type) {
        this.setBackground(this.getBackgroundColor(type));
        super.setOpaque(true);
        Border border = BorderFactory.createLineBorder(this.getBorderColor(type), 1);
        Border marginBorder = BorderFactory.createEmptyBorder(0, 7, 0, 7);
        this.setBorder(BorderFactory.createCompoundBorder(border, marginBorder));
    }

    protected void setHeight(int height) {
        Dimension preferredSize = super.getPreferredSize();
        Dimension maximumSize = super.getMaximumSize();
        preferredSize.height = height;
        maximumSize.height = Integer.MAX_VALUE;
        maximumSize.width = Integer.MAX_VALUE;
        super.setPreferredSize(preferredSize);
        super.setMaximumSize(maximumSize);
    }

    @NotNull
    private Color getBackgroundColor(@NotNull Type type) {
        switch (type) {
            case SUCCESS: {
                return UR_Color.LIGHT_GREEN;
            }
            case INFO: {
                return UR_Color.LIGHT_BLUE;
            }
            case WARNING: {
                return UR_Color.LIGHT_YELLOW;
            }
            case ERROR: {
                return UR_Color.LIGHT_RED;
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    @NotNull
    private Color getBorderColor(@NotNull Type type) {
        switch (type) {
            case SUCCESS: {
                return UR_Color.BRIGHT_GREEN;
            }
            case INFO: {
                return UR_Color.UR_BLUE;
            }
            case WARNING: {
                return UR_Color.GOLD_YELLOW2;
            }
            case ERROR: {
                return UR_Color.GRAY_RED;
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    public static enum Type {
        SUCCESS,
        INFO,
        WARNING,
        ERROR;

    }
}

