/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupData;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.domain.Program;
import com.spin.domain.program_goal.ExtractionGoal;
import com.spin.util.i18n.TextResource;
import com.spin.util.script.ScriptParser;
import com.spin.util.script.ScriptUtil;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DriveScrewScriptGenerator {
    @NotNull
    private final TextResource textResource;

    public DriveScrewScriptGenerator(@NotNull TextResource textResource) {
        this.textResource = textResource;
    }

    @NotNull
    private static InputStream initializationScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("initialization.script"));
    }

    @NotNull
    private static InputStream safeApproachExtractionScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("safe_approach_extraction.script"));
    }

    @NotNull
    private static InputStream safeApproachInsertionScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("safe_approach_insertion.script"));
    }

    @NotNull
    private static InputStream directApproachInsertionScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("direct_approach_insertion.script"));
    }

    @NotNull
    private static InputStream screwProcessScript() {
        return Objects.requireNonNull(DriveScrewScriptGenerator.class.getResourceAsStream("screw_process.script"));
    }

    public void generateScript(@NotNull ScriptWriter scriptWriter, @NotNull ScrewdrivingSetupData data) {
        Program program = Objects.requireNonNull(data.selectedProgram());
        boolean isExtraction = program.goal() instanceof ExtractionGoal;
        boolean useSafeApproach = data.approachIsEnabled();
        String refPoseExpression = data.useSpinTarget() ? scriptWriter.getResolvedVariableName(data.spinTargetVariable()) : ScriptUtil.toScript(Objects.requireNonNull(data.screwPose()));
        ScriptParser parser = new ScriptParser(scriptWriter);
        if (isExtraction) {
            this.generateExtractionScript(parser, program, data, refPoseExpression, useSafeApproach);
        } else {
            this.generateInsertionScript(parser, program, data, refPoseExpression, useSafeApproach);
        }
    }

    private void generateExtractionScript(@NotNull ScriptParser parser, @NotNull Program program, @NotNull ScrewdrivingSetupData data, @NotNull String refPoseExpression, boolean useSafeApproach) {
        String errorPopupTitle = this.textResource.load(ScrewdrivingSetupText.ERROR_TITLE);
        parser.parseToScript(DriveScrewScriptGenerator.initializationScript(), refPoseExpression, Double.toString(program.screw().length().getAs(Length.Unit.M)), Double.toString(program.screw().length().getAs(Length.Unit.M)), errorPopupTitle);
        if (useSafeApproach) {
            parser.parseToScript(DriveScrewScriptGenerator.safeApproachExtractionScript(), this.textResource.load(ScrewdrivingSetupText.ERROR_APPROACH_FOR_EXTRACTION), errorPopupTitle);
        }
        parser.parseToScript(DriveScrewScriptGenerator.screwProcessScript(), Integer.toString(program.id()), Double.toString(data.robotForce().getAs(Force.Unit.N)));
    }

    private void generateInsertionScript(@NotNull ScriptParser parser, @NotNull Program program, @NotNull ScrewdrivingSetupData data, @NotNull String refPoseExpression, boolean useSafeApproach) {
        String errorPopupTitle = this.textResource.load(ScrewdrivingSetupText.ERROR_TITLE);
        parser.parseToScript(DriveScrewScriptGenerator.initializationScript(), refPoseExpression, Double.toString(program.screw().length().getAs(Length.Unit.M)), Double.toString(-data.s1Distance().getAs(Length.Unit.M)), errorPopupTitle);
        if (useSafeApproach) {
            parser.parseToScript(DriveScrewScriptGenerator.safeApproachInsertionScript(), Double.toString(program.screw().length().getAs(Length.Unit.MM)), this.textResource.load(ScrewdrivingSetupText.ERROR_APPROACH_FAILED), errorPopupTitle);
        } else {
            parser.parseToScript(DriveScrewScriptGenerator.directApproachInsertionScript(), Double.toString(program.screw().length().getAs(Length.Unit.MM)));
        }
        parser.parseToScript(DriveScrewScriptGenerator.screwProcessScript(), Integer.toString(program.id()), Double.toString(data.robotForce().getAs(Force.Unit.N)));
    }
}

