/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.toolbar;

import com.spin.api.ExtendedToolbarContext;
import com.spin.core.toolbar.ToolbarConnectionView;
import com.spin.core.toolbar.ToolbarContribution;
import com.spin.core.toolbar.ToolbarDataTableView;
import com.spin.core.toolbar.ToolbarToolControlView;
import com.spin.domain.BridgeInfo;
import com.spin.domain.ProgramResult;
import com.spin.domain.ToolInfo;
import com.spin.i18n.TextResource;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.unit.UnitConverter;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ToolbarView {
    @NotNull
    private final ToolbarConnectionView connectionView;
    @NotNull
    private final ToolbarToolControlView toolControlView;
    @NotNull
    private final ToolbarDataTableView dataTableView;

    ToolbarView(@NotNull ExtendedToolbarContext context, @NotNull ToolbarContribution contribution) {
        TextResource textResource = context.getTextResource();
        UnitConverter unitConverter = context.getUnitConverter();
        this.connectionView = new ToolbarConnectionView();
        this.toolControlView = new ToolbarToolControlView(contribution, textResource);
        this.dataTableView = new ToolbarDataTableView(textResource, unitConverter);
    }

    void buildUI(@NotNull JPanel panel) {
        JPanel connectionPanel = new JPanel();
        JPanel toolControlPanel = new JPanel();
        JPanel dataPanel = new JPanel();
        this.connectionView.buildUI(connectionPanel);
        this.toolControlView.buildUI(toolControlPanel);
        this.dataTableView.buildUI(dataPanel);
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 5, "[top]16[]1[]"));
        panel.add((Component)connectionPanel, "cell 0 0, span 12, grow");
        panel.add((Component)toolControlPanel, "cell 0 1, span 12, grow");
        panel.add((Component)dataPanel, "cell 1 5, span 12, growx");
        this.toolControlView.setToolControlEnabled(false);
        this.registerListeners();
    }

    private void registerListeners() {
        this.toolControlView.registerListeners();
    }

    void addResult(@NotNull ProgramResult result) {
        this.dataTableView.addNewResult(result);
    }

    void setBridgeConnected(@NotNull BridgeInfo ignored) {
        this.connectionView.setBridgeConnected();
    }

    void setBridgeDisconnected() {
        this.connectionView.setBridgeDisconnected();
        this.toolControlView.setMotorRunning(false);
    }

    void setToolConnected(@NotNull ToolInfo info) {
        this.connectionView.setToolConnected();
        this.toolControlView.setToolSpeedLimits(info);
        this.toolControlView.setToolControlEnabled(true);
    }

    void setToolDisconnected() {
        this.connectionView.setToolDisconnected();
        this.toolControlView.setToolControlEnabled(false);
        this.toolControlView.setMotorRunning(false);
    }
}

