/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusListener;
import com.spin.bridge_communication.bridge_connection.BridgeConnectionStatusProvider;
import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupData;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupText;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupView;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewInterface;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewService;
import com.spin.core.program_node.screwdriving_setup.on_fault.OnFaultService;
import com.spin.core.program_node.screwdriving_setup.on_success.OnSuccessService;
import com.spin.domain.BridgeInfo;
import com.spin.domain.Part;
import com.spin.domain.Program;
import com.spin.ui.callback.DoNothingMovementCallback;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.component.keypad.UnitKeypadFactory;
import com.spin.ui.component.keypad.UnitRangeValidator;
import com.spin.visitor.VisitURCapNodeAs;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.AssignmentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.ExpressionAssignmentNodeConfig;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovement;
import com.ur.urcap.api.domain.userinteraction.robot.movement.RobotMovementCallback;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScrewdrivingSetupContribution
implements ProgramNodeContribution {
    @NotNull
    private final ScrewdrivingSetupView view;
    @NotNull
    private final ScrewdrivingSetupData data;
    @NotNull
    private final ProgramModel programModel;
    @NotNull
    private final ExpressionBuilder expressionBuilder;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final RobotMovement robotMovement;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final UnitKeypadFactory unitKeypadFactory;
    @NotNull
    private final String nodeTitle;
    @NotNull
    private final BridgeConnectionStatusProvider bridgeConnectionStatusProvider;
    @NotNull
    private final BridgeConnectionStatusListener bridgeConnectionStatusListener;

    ScrewdrivingSetupContribution(@NotNull ScrewdrivingSetupView view, @NotNull ScrewdrivingSetupData data, @NotNull ExtendedProgramAPIProvider apiProvider, @NotNull CreationContext.NodeCreationType creationType) throws TreeStructureException {
        this.view = view;
        this.data = data;
        this.programModel = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel();
        this.expressionBuilder = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().createExpressionBuilder();
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.robotMovement = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction().getRobotMovement();
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
        this.unitKeypadFactory = apiProvider.getUnitKeypadFactory();
        this.nodeTitle = apiProvider.getTextResource().load(ScrewdrivingSetupText.SCREWDRIVING_SETUP);
        this.bridgeConnectionStatusProvider = ((InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class)).getBridgeConnectionStatusProvider();
        this.bridgeConnectionStatusListener = ScrewdrivingSetupContribution.createBridgeConnectionStatusListener(view);
        view.setUnitConverter(apiProvider.getUnitConverter());
        if (creationType == CreationContext.NodeCreationType.NEW) {
            this.buildSubTree();
        }
    }

    @NotNull
    private static BridgeConnectionStatusListener createBridgeConnectionStatusListener(final @NotNull ScrewdrivingSetupView view) {
        return new BridgeConnectionStatusListener(){

            @Override
            public void onConnected(@NotNull BridgeInfo info) {
                view.setNotConnectedWarningVisible(false);
            }

            @Override
            public void onDisconnected() {
                view.setNotConnectedWarningVisible(true);
            }
        };
    }

    private void buildSubTree() throws TreeStructureException {
        TreeNode rootNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this);
        ProgramNodeFactory factory = this.programModel.getProgramNodeFactory();
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(DriveScrewService.class));
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(OnSuccessService.class));
        rootNode.addChild((ProgramNode)factory.createURCapProgramNode(OnFaultService.class));
        rootNode.setChildSequenceLocked(true);
    }

    public void openView() {
        this.updateSelectors();
        this.updateTeachAndVerifyButtons();
        this.updateBridgeConnectionStatus();
        this.updateApproachEnabledCheckBox();
        this.updateUseSpinTargetCheckBox();
        this.updateRobotForceInputField();
        this.updateS1InputField();
        this.data.setOnPartsChangedCallback(this::updateSelectors);
        this.bridgeConnectionStatusProvider.registerListener(this.bridgeConnectionStatusListener);
    }

    public void closeView() {
        this.data.clearOnPartsChangedCallback();
        this.bridgeConnectionStatusProvider.unregisterListener(this.bridgeConnectionStatusListener);
    }

    @NotNull
    public String getTitle() {
        Program selectedProgram = this.data.selectedProgram();
        return selectedProgram == null ? this.nodeTitle : this.nodeTitle + ": " + selectedProgram.name();
    }

    public boolean isDefined() {
        return this.data.isValid();
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        this.configureSubTree();
        writer.writeChildren();
    }

    private void configureSubTree() {
        this.programModel.getRootTreeNode((ProgramNodeContribution)this).traverse(new VisitURCapNodeAs<DriveScrewInterface>(DriveScrewInterface.class, (node, index, depth) -> node.setData(this.data)));
    }

    void setSpinTargetEnabled(boolean enable) {
        this.undoRedoManager.recordChanges(() -> {
            this.data.setUseSpinTarget(enable);
            this.enableSpinTargetInProgramTree(enable);
        });
    }

    void setSelectedPart(@NotNull Part selectedPart) {
        this.data.setSelectedPart(selectedPart);
        this.data.clearSelectedProgram();
        List<Program> programs = selectedPart.programs();
        this.view.setPrograms(programs);
        this.view.selectProgram(null);
        this.view.setNoProgramsWarningVisible(programs.isEmpty());
        this.view.enableProgramSelector(!programs.isEmpty());
    }

    void setSelectedProgram(@NotNull Program selectedProgram) {
        this.data.setSelectedProgram(selectedProgram);
    }

    void setRobotForce(@NotNull Force force) {
        this.data.setRobotForce(force);
    }

    void setS1Distance(@NotNull Length distance) {
        this.data.setS1Distance(distance);
    }

    void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    void getUserDefinedRobotPosition(@NotNull RobotPositionCallback2 callback) {
        this.userInteraction.getUserDefinedRobotPosition(callback);
    }

    void setScrewPose(@NotNull Pose pose) {
        this.data.setScrewPose(pose);
        this.view.setButtonStyleAsReteach();
    }

    void moveToScrew() {
        Pose screwPose = this.data.screwPose();
        assert (screwPose != null);
        this.robotMovement.requestUserToMoveRobot(screwPose, (RobotMovementCallback)new DoNothingMovementCallback());
    }

    UnitKeypad<Integer, Length> getS1LengthIntegerKeypad(@Nullable Length initialLength) {
        UnitKeypad<Integer, Length> keypad = this.unitKeypadFactory.createPositiveIntegerKeypad(Length.class);
        UnitRangeValidator<Integer, Length> validator = this.unitKeypadFactory.createIntegerRangeValidator(Length.class, this.data.minAllowedS1Distance(), this.data.maxAllowedS1Distance());
        keypad.setInitialValue(initialLength);
        keypad.setErrorValidator(validator);
        return keypad;
    }

    public UnitKeypad<Double, Length> getS1LengthDoubleKeypad(@Nullable Length initialLength) {
        UnitKeypad<Double, Length> keypad = this.unitKeypadFactory.createPositiveDoubleKeypad(Length.class);
        UnitRangeValidator<Double, Length> validator = this.unitKeypadFactory.createDoubleRangeValidator(Length.class, this.data.minAllowedS1Distance(), this.data.maxAllowedS1Distance());
        keypad.setInitialValue(initialLength);
        keypad.setErrorValidator(validator);
        return keypad;
    }

    public UnitKeypad<Integer, Force> getRobotForceIntegerKeypad(@Nullable Force initialValue) {
        UnitKeypad<Integer, Force> keypad = this.unitKeypadFactory.createPositiveIntegerKeypad(Force.class);
        keypad.setInitialValue(initialValue);
        return keypad;
    }

    @NotNull
    UnitKeypad<Double, Force> getRobotForceDoubleKeypad(@Nullable Force initialValue) {
        UnitKeypad<Double, Force> keypad = this.unitKeypadFactory.createPositiveDoubleKeypad(Force.class);
        keypad.setInitialValue(initialValue);
        return keypad;
    }

    private void enableSpinTargetInProgramTree(boolean enable) {
        try {
            if (enable) {
                this.addSpinTargetNode();
            } else {
                this.removeSpinTargetNode();
            }
        }
        catch (TreeStructureException e) {
            throw new RuntimeException(e);
        }
    }

    private void addSpinTargetNode() throws TreeStructureException {
        TreeNode rootNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this);
        TreeNode firstNode = (TreeNode)rootNode.getChildren().get(0);
        rootNode.insertChildBefore(firstNode, (ProgramNode)this.createSpinTargetNode());
    }

    @NotNull
    private AssignmentNode createSpinTargetNode() {
        AssignmentNode assignmentNode = this.programModel.getProgramNodeFactory().createAssignmentNode();
        ExpressionAssignmentNodeConfig config = assignmentNode.getConfigFactory().createExpressionConfig(this.data.spinTargetVariable(), this.createEmptyExpression());
        assignmentNode.setConfig((AssignmentNodeConfig)config);
        return assignmentNode;
    }

    @NotNull
    private Expression createEmptyExpression() {
        try {
            return this.expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeSpinTargetNode() throws TreeStructureException {
        TreeNode rootNode = this.programModel.getRootTreeNode((ProgramNodeContribution)this);
        TreeNode firstNode = (TreeNode)rootNode.getChildren().get(0);
        assert (firstNode.getProgramNode() instanceof AssignmentNode);
        rootNode.removeChild(firstNode);
    }

    private void updateSelectors() {
        Set<Part> availableParts = this.data.availableParts();
        List<Program> availablePrograms = this.data.availablePrograms();
        Part selectedPart = this.data.selectedPart();
        Program selectedProgram = this.data.selectedProgram();
        this.view.setParts(availableParts);
        this.view.selectPart(selectedPart);
        this.view.enablePartSelector(!availableParts.isEmpty());
        this.view.setNoPartsWarningVisible(availableParts.isEmpty());
        this.view.setPrograms(availablePrograms);
        this.view.selectProgram(selectedProgram);
        this.view.enableProgramSelector(!availablePrograms.isEmpty());
        this.view.setNoProgramsWarningVisible(!availableParts.isEmpty() && availablePrograms.isEmpty());
    }

    private void updateTeachAndVerifyButtons() {
        if (this.data.screwPose() == null) {
            this.view.setButtonStyleAsTeach();
            this.view.enableVerifyPositionButton(false);
        } else {
            this.view.setButtonStyleAsReteach();
            this.view.enableVerifyPositionButton(true);
        }
    }

    private void updateBridgeConnectionStatus() {
        this.view.setNotConnectedWarningVisible(!this.bridgeConnectionStatusProvider.isConnected());
    }

    private void updateS1InputField() {
        this.view.setS1value(this.data.s1Distance());
    }

    private void updateRobotForceInputField() {
        this.view.setRobotForceValue(this.data.robotForce());
    }

    private void updateUseSpinTargetCheckBox() {
        this.view.setSpinTargetEnabled(this.data.useSpinTarget());
    }

    private void updateApproachEnabledCheckBox() {
        this.view.setApproachEnabled(this.data.approachIsEnabled());
    }
}

