/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bridge_tool;

import com.spin.api.ExtendedViewAPIProvider;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolContribution;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolText;
import com.spin.domain.BridgeInfo;
import com.spin.domain.ToolInfo;
import com.spin.i18n.TextResource;
import com.spin.ui.callback.OnOkCallback;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.inputfield.InputField;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.urstyle.UR_Color;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.Component;
import java.awt.LayoutManager;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BridgeAndToolView
implements SwingInstallationNodeView<BridgeAndToolContribution> {
    @NotNull
    private final ImageIcon connectionOKIcon;
    @NotNull
    private final ImageIcon connectionNotOKIcon;
    @NotNull
    private final ImageIcon connectionUnknownIcon;
    @NotNull
    private final ImagePanel bridgeConnectionImage;
    @NotNull
    private final ImagePanel toolConnectionImage;
    @NotNull
    private final InputField<InetAddress> ipAddressField;
    @NotNull
    private final JPanel bridgeDetails;
    @NotNull
    private final JPanel toolDetails;
    @NotNull
    private final Label bridgeSerialNumber;
    @NotNull
    private final Label bridgeSoftwareVersion;
    @NotNull
    private final Label toolSerialNumber;
    @NotNull
    private final Label toolSoftwareVersion;
    @NotNull
    private final TextResource textResource;
    @Nullable
    private BridgeInfo connectedBridgeInfo = null;
    @Nullable
    private ToolInfo connectedToolInfo = null;

    public BridgeAndToolView(@NotNull ExtendedViewAPIProvider apiProvider) {
        this.textResource = apiProvider.getTextResource();
        this.connectionOKIcon = SpinIcon.CONNECTION_OK.load();
        this.connectionNotOKIcon = SpinIcon.CONNECTION_NOT_OK.load();
        this.connectionUnknownIcon = SpinIcon.CONNECTION_UNKNOWN.load();
        this.bridgeConnectionImage = new ImagePanel(this.connectionNotOKIcon);
        this.toolConnectionImage = new ImagePanel(this.connectionNotOKIcon);
        this.bridgeSerialNumber = new Label();
        this.bridgeSoftwareVersion = new Label();
        this.toolSerialNumber = new Label();
        this.toolSoftwareVersion = new Label();
        this.ipAddressField = new InputField(InputField.Alignment.NUMBER);
        this.ipAddressField.setRenderer(value -> value == null ? null : value.getHostAddress());
        this.bridgeDetails = new JPanel((LayoutManager)new MigLayout("insets 10, gap 20", "[][grow]", ""));
        this.toolDetails = new JPanel((LayoutManager)new MigLayout("insets 10, gap 20", "[][grow]", ""));
        this.bridgeDetails.setBorder(BorderFactory.createLineBorder(UR_Color.GRAY4, 5));
        this.toolDetails.setBorder(BorderFactory.createLineBorder(UR_Color.GRAY4, 5));
        String serialNumber = this.textResource.load(BridgeAndToolText.SERIAL_NUMBER);
        String softwareVersion = this.textResource.load(BridgeAndToolText.SOFTWARE_VERSION);
        this.bridgeDetails.add((Component)new Label(serialNumber), "cell 0 0");
        this.bridgeDetails.add((Component)this.bridgeSerialNumber, "cell 1 0");
        this.bridgeDetails.add((Component)new Label(softwareVersion), "cell 0 1");
        this.bridgeDetails.add((Component)this.bridgeSoftwareVersion, "cell 1 1");
        this.toolDetails.add((Component)new Label(serialNumber), "cell 0 0");
        this.toolDetails.add((Component)this.toolSerialNumber, "cell 1 0");
        this.toolDetails.add((Component)new Label(softwareVersion), "cell 0 1");
        this.toolDetails.add((Component)this.toolSoftwareVersion, "cell 1 1");
    }

    public void buildUI(@NotNull JPanel panel, @NotNull BridgeAndToolContribution contribution) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 20, "[]push[center]5[]40[top]push"));
        panel.add((Component)new ImagePanel(SpinIcon.LOGO_INSTALLATION_NODE.load()), "cell 9 0, span 3, right");
        panel.add((Component)new ImagePanel(SpinImage.ROBOT.load()), "cell 0 1, span 2, align 70%");
        panel.add((Component)new ImagePanel(SpinImage.BRIDGE.load()), "cell 3 1, span 5, align 60%");
        panel.add((Component)new ImagePanel(SpinImage.TOOL.load()), "cell 8 1, span 4, align 56%");
        panel.add((Component)this.bridgeConnectionImage, "cell 2 1, span 3");
        panel.add((Component)this.toolConnectionImage, "cell 7 1, span 3");
        String ipAddress = this.textResource.load(BridgeAndToolText.IP_ADDRESS);
        panel.add((Component)new Label(ipAddress), "cell 3 2, span 2, right");
        panel.add((Component)this.ipAddressField.getTextField(), "cell 5 2, span 2, grow");
        panel.add((Component)this.bridgeDetails, "cell 3 3, span 5, grow");
        panel.add((Component)this.toolDetails, "cell 8 3, span 4, grow");
        this.registerListeners(contribution);
    }

    private void registerListeners(@NotNull BridgeAndToolContribution contribution) {
        this.ipAddressField.getTextField().addSimpleClickListener(() -> this.showBridgeIPKeyboard(contribution));
    }

    private void showBridgeIPKeyboard(@NotNull BridgeAndToolContribution contribution) {
        KeyboardTextInput keyboard = contribution.getBridgeIPKeyboard();
        keyboard.show((JTextField)this.ipAddressField.getTextField(), new OnOkCallback<String>(addressString -> this.updateBridgeIP(contribution, (String)addressString)));
    }

    private void updateBridgeIP(@NotNull BridgeAndToolContribution contribution, @NotNull String addressString) {
        InetAddress ipAddress = this.asInetAddress(addressString);
        contribution.onBridgeIPChanged(ipAddress);
        this.setBridgeIPAddress(ipAddress);
    }

    @NotNull
    private InetAddress asInetAddress(@NotNull String addressString) {
        try {
            return Inet4Address.getByName(addressString);
        }
        catch (UnknownHostException e) {
            assert (false) : "Invalid address entered. This should not be possible.";
            throw new RuntimeException(e);
        }
    }

    void setBridgeIPAddress(@NotNull InetAddress address) {
        this.ipAddressField.setValue(address);
    }

    void setBridgeDisconnected() {
        this.connectedBridgeInfo = null;
        this.updateBridgeConnection();
        this.updateToolConnection();
    }

    void setBridgeConnected(@NotNull BridgeInfo bridgeInfo) {
        this.connectedBridgeInfo = bridgeInfo;
        this.updateBridgeConnection();
        this.updateToolConnection();
    }

    void setToolDisconnected() {
        this.connectedToolInfo = null;
        this.updateToolConnection();
    }

    void setToolConnected(@NotNull ToolInfo toolInfo) {
        this.connectedToolInfo = toolInfo;
        this.updateToolConnection();
    }

    private void updateBridgeConnection() {
        if (this.connectedBridgeInfo == null) {
            this.showBridgeDisconnected();
        } else {
            this.showBridgeConnected(this.connectedBridgeInfo);
        }
    }

    private void updateToolConnection() {
        if (this.connectedBridgeInfo == null) {
            this.showToolConnectionUnknown();
        } else if (this.connectedToolInfo == null) {
            this.showToolDisconnected();
        } else {
            this.showToolConnected(this.connectedToolInfo);
        }
    }

    private void showBridgeDisconnected() {
        this.bridgeConnectionImage.setIcon(this.connectionNotOKIcon);
        this.bridgeDetails.setVisible(false);
    }

    private void showBridgeConnected(@NotNull BridgeInfo bridgeInfo) {
        this.bridgeSerialNumber.setText(bridgeInfo.serialNumber().toString());
        this.bridgeSoftwareVersion.setText(bridgeInfo.softwareVersion().toString());
        this.bridgeConnectionImage.setIcon(this.connectionOKIcon);
        this.bridgeDetails.setVisible(true);
    }

    private void showToolConnectionUnknown() {
        this.toolConnectionImage.setIcon(this.connectionUnknownIcon);
        this.toolDetails.setVisible(false);
    }

    private void showToolDisconnected() {
        this.toolConnectionImage.setIcon(this.connectionNotOKIcon);
        this.toolDetails.setVisible(false);
    }

    void showToolConnected(@NotNull ToolInfo toolInfo) {
        this.toolConnectionImage.setIcon(this.connectionOKIcon);
        this.toolSerialNumber.setText(toolInfo.serialNumber().toString());
        this.toolSoftwareVersion.setText(toolInfo.softwareVersion().toString());
        this.toolDetails.setVisible(true);
    }
}

