/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.screw_feeder;

import com.spin.api.ExtendedViewAPIProvider;
import com.spin.core.installation_node.screw_feeder.EditFeederView;
import com.spin.core.installation_node.screw_feeder.FeederDetailsView;
import com.spin.core.installation_node.screw_feeder.ScrewFeederContribution;
import com.spin.core.installation_node.screw_feeder.VerifyFeederPositionView;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.layout.UR_MigLayout;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ScrewFeederView
implements SwingInstallationNodeView<ScrewFeederContribution> {
    @NotNull
    private final FeederDetailsView detailsView;
    @NotNull
    private final EditFeederView editFeederView;
    @NotNull
    private final VerifyFeederPositionView verifyPositionView;
    @NotNull
    private final JPanel detailsPanel;
    @NotNull
    private final JPanel editFeederPanel;
    @NotNull
    private final JPanel verifyPositionPanel;

    public ScrewFeederView(@NotNull ExtendedViewAPIProvider apiProvider) {
        this.detailsView = new FeederDetailsView(apiProvider);
        this.editFeederView = new EditFeederView(apiProvider);
        this.verifyPositionView = new VerifyFeederPositionView(apiProvider);
        this.detailsPanel = this.detailsView.createPanel();
        this.editFeederPanel = this.editFeederView.createPanel();
        this.verifyPositionPanel = this.verifyPositionView.createPanel();
    }

    public void buildUI(@NotNull JPanel panel, @NotNull ScrewFeederContribution contribution) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 20, "[][grow]"));
        ImagePanel image = new ImagePanel(SpinImage.SCREW_FEEDER.load());
        panel.add((Component)this.detailsPanel, "cell 0 0, span 6 2, grow, hidemode 3");
        panel.add((Component)this.editFeederPanel, "cell 0 0, span 6 2, grow, hidemode 3");
        panel.add((Component)this.verifyPositionPanel, "cell 0 0, span 6 2, grow, hidemode 3");
        panel.add((Component)new ImagePanel(SpinIcon.LOGO_INSTALLATION_NODE.load()), "cell 9 0, span 3, right");
        panel.add((Component)image, "cell 6 1, span 6, bottom, center");
        this.detailsView.registerListeners(contribution);
        this.editFeederView.registerListeners(contribution);
        this.verifyPositionView.registerListeners(contribution);
    }

    @NotNull
    FeederDetailsView getDetailsView() {
        return this.detailsView;
    }

    @NotNull
    EditFeederView getEditView() {
        return this.editFeederView;
    }

    @NotNull
    VerifyFeederPositionView getVerifyPositionView() {
        return this.verifyPositionView;
    }

    void setActivePanel(@NotNull Panel activePanel) {
        this.detailsPanel.setVisible(activePanel == Panel.DETAILS);
        this.editFeederPanel.setVisible(activePanel == Panel.EDIT_FEEDER);
        this.verifyPositionPanel.setVisible(activePanel == Panel.VERIFY_POSITION);
    }

    static enum Panel {
        DETAILS,
        EDIT_FEEDER,
        VERIFY_POSITION;

    }
}

