/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.screw_feeder;

import com.spin.core.installation_node.screw_feeder.ScrewFeederContribution;
import com.spin.core.installation_node.screw_feeder.ScrewFeederText;
import com.spin.domain.ScrewFeeder;
import com.spin.ui.callback.OnOkCallback;
import com.spin.ui.callback.OnOkPositionCallback;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.Label;
import com.spin.ui.component.inputfield.InputField;
import com.spin.ui.component.inputfield.UnitRenderer;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.unit.UnitConverter;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditFeederView {
    @NotNull
    private final UnitType unitType;
    @NotNull
    private final Label nameLabel;
    @NotNull
    private final Label screwLengthLabel;
    @NotNull
    private final Label screwLengthUnit;
    @NotNull
    private final InputField<String> nameValue;
    @NotNull
    private final InputField<Length> screwLengthValue;
    @NotNull
    private final JButton teachPositionButton;
    @NotNull
    private final JButton verifyPositionButton;
    @NotNull
    private final JButton okButton;
    @NotNull
    private final JButton cancelButton;
    @NotNull
    private UUID feederID = UUID.randomUUID();
    @Nullable
    private Pose definedPose = null;
    @Nullable
    private JointPositions definedJointPositions = null;

    EditFeederView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        this.unitType = apiProvider.getViewAPIProvider().getSystemAPI().getSystemSettings().getLocalization().getUnitType();
        ImageIcon moveTeachIcon = UR_Icon.MOVE_TEACH.load();
        ImageIcon wizardIcon = UR_Icon.WIZARD.load();
        ImageIcon approveIcon = UR_Icon.APPROVE.load();
        ImageIcon cancelIcon = UR_Icon.CANCEL.load();
        this.teachPositionButton = new ButtonMedium(textResource.load(ScrewFeederText.TEACH_POSITION), moveTeachIcon);
        this.verifyPositionButton = new ButtonMedium(textResource.load(ScrewFeederText.VERIFY_POSITION), wizardIcon);
        this.okButton = new ButtonMedium(textResource.load(ScrewFeederText.OK), approveIcon);
        this.cancelButton = new ButtonMedium(textResource.load(ScrewFeederText.CANCEL), cancelIcon);
        this.nameLabel = new Label(textResource.load(ScrewFeederText.NAME));
        this.screwLengthLabel = new Label(textResource.load(ScrewFeederText.SCREW_LENGTH));
        this.screwLengthUnit = new Label();
        this.nameValue = new InputField(InputField.Alignment.TEXT);
        this.screwLengthValue = new InputField(InputField.Alignment.NUMBER);
    }

    @NotNull
    JPanel createPanel() {
        JPanel panel = new JPanel((LayoutManager)UR_MigLayout.equalColumns(6, 20, "30[]10[]10[]50[]10[]50[]push"));
        panel.add((Component)this.nameLabel, "cell 1 0, span 4");
        panel.add((Component)this.nameValue.getTextField(), "cell 1 1, span 4, grow");
        panel.add((Component)this.screwLengthLabel, "cell 1 2, span 2");
        panel.add((Component)this.screwLengthValue.getTextField(), "cell 3 2, grow");
        panel.add((Component)this.screwLengthUnit, "cell 4 2");
        panel.add((Component)this.teachPositionButton, "cell 1 3, span 4, grow");
        panel.add((Component)this.verifyPositionButton, "cell 1 4, span 4, grow");
        panel.add((Component)this.okButton, "cell 1 5, span 2, grow");
        panel.add((Component)this.cancelButton, "cell 3 5, span 2, grow");
        return panel;
    }

    void registerListeners(@NotNull ScrewFeederContribution contribution) {
        this.nameValue.getTextField().addSimpleClickListener(() -> this.showNameKeyboard(contribution));
        this.screwLengthValue.getTextField().addSimpleClickListener(() -> this.showScrewLengthKeypad(contribution));
        this.teachPositionButton.addActionListener(event -> this.getUserDefinedFeederPosition(contribution));
        this.verifyPositionButton.addActionListener(event -> this.showVerifyPositionWizard(contribution));
        this.okButton.addActionListener(event -> {
            this.addFeederFromEnteredValues(contribution);
            contribution.onExitEditFeeder();
        });
        this.cancelButton.addActionListener(event -> contribution.onExitEditFeeder());
    }

    void setUnitConverter(@NotNull UnitConverter unitConverter) {
        UnitRenderer renderer = new UnitRenderer(unitConverter, new DecimalFormat("#.##"));
        String unit = unitConverter.labelOf(Length.class);
        this.screwLengthUnit.setText(unit);
        this.screwLengthValue.setRenderer(renderer);
    }

    void clearFeeder() {
        this.feederID = UUID.randomUUID();
        this.nameValue.setValue(null);
        this.screwLengthValue.setValue(null);
        this.definedPose = null;
        this.definedJointPositions = null;
        this.nameValue.getTextField().setInputValid(false);
        this.screwLengthValue.getTextField().setInputValid(false);
        this.verifyPositionButton.setEnabled(false);
        this.okButton.setEnabled(false);
    }

    void setFeeder(@NotNull ScrewFeeder feeder) {
        this.feederID = feeder.id();
        this.nameValue.setValue(feeder.name());
        this.screwLengthValue.setValue(feeder.screwLength());
        this.definedPose = feeder.pickUpPose();
        this.definedJointPositions = feeder.pickUpJointPositions();
        this.nameValue.getTextField().setInputValid(true);
        this.screwLengthValue.getTextField().setInputValid(true);
        this.verifyPositionButton.setEnabled(true);
        this.okButton.setEnabled(true);
    }

    private void addFeederFromEnteredValues(@NotNull ScrewFeederContribution contribution) {
        assert (this.nameValue.getValue() != null);
        assert (this.definedPose != null);
        assert (this.definedJointPositions != null);
        assert (this.screwLengthValue.getValue() != null);
        contribution.storeFeeder(new ScrewFeeder(this.feederID, this.nameValue.getValue(), this.definedPose, this.definedJointPositions, this.screwLengthValue.getValue()));
    }

    private void enableOKButtonIfAllIsConfigured() {
        boolean nameIsConfigured = this.nameValue.getValue() != null;
        boolean screwLengthIsConfigured = this.screwLengthValue.getValue() != null;
        boolean poseIsConfigured = this.definedPose != null && this.definedJointPositions != null;
        this.okButton.setEnabled(nameIsConfigured && screwLengthIsConfigured && poseIsConfigured);
    }

    private void showNameKeyboard(@NotNull ScrewFeederContribution contribution) {
        KeyboardTextInput keyboard = contribution.getFeederNameKeyboard(this.nameValue.getValue());
        keyboard.show((JTextField)this.nameValue.getTextField(), new OnOkCallback<String>(name -> {
            this.nameValue.setValue((String)name);
            this.nameValue.getTextField().setInputValid(true);
            this.enableOKButtonIfAllIsConfigured();
        }));
    }

    private void showScrewLengthKeypad(@NotNull ScrewFeederContribution contribution) {
        Length initialValue = this.screwLengthValue.getValue();
        UnitKeypad<Number, Length> keypad = this.unitType == UnitType.METRIC ? contribution.getScrewLengthIntegerKeypad(initialValue) : contribution.getScrewLengthDoubleKeypad(initialValue);
        keypad.show(this.screwLengthValue.getTextField(), length -> {
            this.screwLengthValue.setValue((Length)length);
            this.screwLengthValue.getTextField().setInputValid(true);
            this.enableOKButtonIfAllIsConfigured();
        });
    }

    private void getUserDefinedFeederPosition(@NotNull ScrewFeederContribution contribution) {
        contribution.getUserInteraction().getUserDefinedRobotPosition((RobotPositionCallback2)new OnOkPositionCallback(parameters -> {
            this.definedPose = parameters.getPose();
            this.definedJointPositions = parameters.getJointPositions();
            this.verifyPositionButton.setEnabled(true);
            this.enableOKButtonIfAllIsConfigured();
        }));
    }

    private void showVerifyPositionWizard(@NotNull ScrewFeederContribution contribution) {
        assert (this.definedPose != null);
        contribution.onVerifyNewPosition(this.definedPose);
    }
}

