/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.attach_bit;

import com.spin.core.program_node.attach_bit.AttachBitContribution;
import com.spin.core.program_node.attach_bit.AttachBitText;
import com.spin.domain.BitChangingStation;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.CheckBox;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.component.RadioButton;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachBitView
implements SwingProgramNodeView<AttachBitContribution> {
    @NotNull
    private final ImagePanel logo;
    @NotNull
    private final ComboBox<BitChangingStation> bitStationSelector;
    @NotNull
    private final RadioButton bit1Selector;
    @NotNull
    private final RadioButton bit2Selector;
    @NotNull
    private final RadioButton bit3Selector;
    @NotNull
    private final Label setupMissingLabel;
    @NotNull
    private final ImagePanel bitStationImage;
    @NotNull
    private final ImageIcon bitStationBlank;
    @NotNull
    private final ImageIcon bitStationBit1;
    @NotNull
    private final ImageIcon bitStationBit2;
    @NotNull
    private final ImageIcon bitStationBit3;
    @NotNull
    private final JPanel bitSelectorPanel;
    @NotNull
    private final CheckBox approachCheckBox;
    @NotNull
    private final MessageBoxSmall approachWarning;
    @NotNull
    private final CheckBox departureCheckBox;
    @NotNull
    private final MessageBoxSmall departureWarning;
    @NotNull
    private final JPanel approachAndDeparturePanel;
    @NotNull
    private final Map<BitChangingStation.Bit, Runnable> bitSelectionFunctions = new HashMap<BitChangingStation.Bit, Runnable>();
    @Nullable
    private BitChangingStation.Bit selectedBit = null;

    AttachBitView(@NotNull ExtendedViewAPIProvider apiProvider) {
        TextResource textResource = apiProvider.getTextResource();
        this.logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        this.bitStationSelector = new ComboBox();
        this.bitStationSelector.setDefaultText(textResource.load(AttachBitText.NONE));
        this.bit1Selector = new RadioButton();
        this.bit2Selector = new RadioButton();
        this.bit3Selector = new RadioButton();
        this.setupMissingLabel = new Label(textResource.load(AttachBitText.MISSING_SETUP), UR_Icon.WARNING_SMALL.load(), 2);
        Dimension dimension = new Dimension(-1, 180);
        this.bitStationBlank = SpinImage.BIT_CHANGING_STATION.load(dimension);
        this.bitStationBit1 = SpinImage.BIT_CHANGING_STATION_BIT_1.load(dimension);
        this.bitStationBit2 = SpinImage.BIT_CHANGING_STATION_BIT_2.load(dimension);
        this.bitStationBit3 = SpinImage.BIT_CHANGING_STATION_BIT_3.load(dimension);
        this.bitStationImage = new ImagePanel(this.bitStationBlank);
        ButtonGroup bitSelectors = new ButtonGroup();
        bitSelectors.add(this.bit2Selector);
        bitSelectors.add(this.bit3Selector);
        bitSelectors.add(this.bit1Selector);
        this.bitSelectionFunctions.put(null, () -> {
            bitSelectors.clearSelection();
            this.bitStationImage.setIcon(this.bitStationBlank);
        });
        this.bitSelectionFunctions.put(BitChangingStation.Bit.BIT_1, () -> {
            this.bit1Selector.setSelected(true);
            this.bitStationImage.setIcon(this.bitStationBit1);
        });
        this.bitSelectionFunctions.put(BitChangingStation.Bit.BIT_2, () -> {
            this.bit2Selector.setSelected(true);
            this.bitStationImage.setIcon(this.bitStationBit2);
        });
        this.bitSelectionFunctions.put(BitChangingStation.Bit.BIT_3, () -> {
            this.bit3Selector.setSelected(true);
            this.bitStationImage.setIcon(this.bitStationBit3);
        });
        this.bitSelectorPanel = new JPanel((LayoutManager)new MigLayout("", "[grow]12[]67[]68[][grow]", "[][][]push"));
        this.bitSelectorPanel.add((Component)this.bitStationImage, "cell 0 0, span 5, grow");
        this.bitSelectorPanel.add((Component)this.bit1Selector, "cell 1 1");
        this.bitSelectorPanel.add((Component)this.bit2Selector, "cell 2 1");
        this.bitSelectorPanel.add((Component)this.bit3Selector, "cell 3 1");
        this.approachCheckBox = new CheckBox(textResource.load(AttachBitText.APPROACH_ENABLE));
        this.approachWarning = new MessageBoxSmall(textResource.load(AttachBitText.APPROACH_WARNING), AbstractMessageBox.Type.WARNING);
        this.departureCheckBox = new CheckBox(textResource.load(AttachBitText.DEPART_ENABLE));
        this.departureWarning = new MessageBoxSmall(textResource.load(AttachBitText.DEPART_WARNING), AbstractMessageBox.Type.WARNING);
        this.approachAndDeparturePanel = new JPanel();
        this.approachAndDeparturePanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[][][][]"));
        this.approachAndDeparturePanel.add((Component)this.approachCheckBox, "cell 0 0");
        this.approachAndDeparturePanel.add((Component)this.approachWarning, "cell 0 1, span 12, left, hidemode 3");
        this.approachAndDeparturePanel.add((Component)this.departureCheckBox, "cell 0 2");
        this.approachAndDeparturePanel.add((Component)this.departureWarning, "cell 0 3, span 12, left, hidemode 3");
    }

    public void buildUI(@NotNull JPanel panel, @NotNull ContributionProvider<AttachBitContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[top][][][]push[][][][]push[]"));
        panel.add(this.bitStationSelector, "cell 0 0, span 7, grow");
        panel.add((Component)this.bitSelectorPanel, "cell 0 2, span 7 2, hidemode 3");
        panel.add((Component)this.setupMissingLabel, "cell 0 2, span 5, gaptop 10, hidemode 3");
        panel.add((Component)this.approachAndDeparturePanel, "cell 0 4, span 12 4, growx, hidemode 3");
        panel.add((Component)this.logo, "cell 0 8, span 4 2");
        this.registerListeners(provider);
        this.show_bitStation_image_for(null);
    }

    private void registerListeners(@NotNull ContributionProvider<AttachBitContribution> provider) {
        this.bitStationSelector.addActionListener(event -> {
            BitChangingStation selectedStation = (BitChangingStation)this.bitStationSelector.getSelectedItem();
            if (selectedStation != null) {
                ((AttachBitContribution)provider.get()).selectStation(selectedStation);
                this.setPanelVisibility(false);
            }
        });
        Consumer<BitChangingStation.Bit> updateSelectionIfChanged = bit -> {
            if (this.selectedBit != bit) {
                ((AttachBitContribution)provider.get()).selectBit((BitChangingStation.Bit)((Object)bit));
                this.show_bitStation_image_for((BitChangingStation.Bit)((Object)bit));
            }
            this.selectedBit = bit;
        };
        this.bit1Selector.addActionListener(event -> updateSelectionIfChanged.accept(BitChangingStation.Bit.BIT_1));
        this.bit2Selector.addActionListener(event -> updateSelectionIfChanged.accept(BitChangingStation.Bit.BIT_2));
        this.bit3Selector.addActionListener(event -> updateSelectionIfChanged.accept(BitChangingStation.Bit.BIT_3));
        this.approachCheckBox.addActionListener(event -> {
            boolean enabled = this.approachCheckBox.isSelected();
            ((AttachBitContribution)provider.get()).setApproachEnabled(enabled);
            this.approachWarning.setVisible(!enabled);
        });
        this.departureCheckBox.addActionListener(event -> {
            boolean enabled = this.departureCheckBox.isSelected();
            ((AttachBitContribution)provider.get()).setDepartEnabled(enabled);
            this.departureWarning.setVisible(!enabled);
        });
    }

    void setSelectedBit(@Nullable BitChangingStation.Bit bit) {
        this.selectedBit = bit;
        this.bitSelectionFunctions.get((Object)bit).run();
    }

    void setSelectedStation(@Nullable BitChangingStation bitChangingStation) {
        this.bitStationSelector.setSelectedItem(bitChangingStation);
        this.setPanelVisibility(bitChangingStation == null);
    }

    void setApproachEnabled(boolean enabled) {
        this.approachCheckBox.setSelected(enabled);
        this.approachWarning.setVisible(!enabled);
    }

    void setDepartEnabled(boolean enabled) {
        this.departureCheckBox.setSelected(enabled);
        this.departureWarning.setVisible(!enabled);
    }

    void setStations(@NotNull Set<BitChangingStation> stations) {
        this.bitStationSelector.runWithoutFiringActionsEvents(() -> {
            this.bitStationSelector.removeAllItems();
            stations.stream().sorted(Comparator.comparing(station -> station.name().toLowerCase()).thenComparing(BitChangingStation::name)).forEach(this.bitStationSelector::addItem);
        });
        this.setupMissingLabel.setVisible(stations.isEmpty());
    }

    void setPanelVisibility(boolean visible) {
        this.bitSelectorPanel.setVisible(!visible);
        this.approachAndDeparturePanel.setVisible(!visible);
    }

    void show_bitStation_image_for(@Nullable BitChangingStation.Bit bit) {
        if (bit == null) {
            this.bitStationImage.setIcon(this.bitStationBlank);
        }
        if (bit == BitChangingStation.Bit.BIT_1) {
            this.bitStationImage.setIcon(this.bitStationBit1);
        }
        if (bit == BitChangingStation.Bit.BIT_2) {
            this.bitStationImage.setIcon(this.bitStationBit2);
        }
        if (bit == BitChangingStation.Bit.BIT_3) {
            this.bitStationImage.setIcon(this.bitStationBit3);
        }
    }
}

