/*
 * Decompiled with CFR 0.152.
 */
package com.spin;

import com.spin.bridge_communication.proxy.BridgeProxyFactoryImpl;
import com.spin.bridge_communication.proxy.factory.ConnectionFactory;
import com.spin.core.installation_node.InstallationService;
import com.spin.core.program_node.attach_bit.AttachBitService;
import com.spin.core.program_node.detach_bit.DetachBitService;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayService;
import com.spin.core.program_node.load_screw.LoadScrewService;
import com.spin.core.program_node.move_to_screw.MoveToScrewService;
import com.spin.core.program_node.safe_approach.SafeApproachService;
import com.spin.core.program_node.screwdriving_setup.ScrewdrivingSetupService;
import com.spin.core.program_node.screwdriving_setup.approach.ApproachService;
import com.spin.core.program_node.screwdriving_setup.drive_screw.DriveScrewService;
import com.spin.core.program_node.screwdriving_setup.on_Fault.OnFaultService;
import com.spin.core.program_node.screwdriving_setup.on_OK.OnOkService;
import com.spin.core.program_node.screwdriving_setup.on_not_OK.OnNotOkService;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.unload_screw.UnloadScrewService;
import com.spin.core.toolbar.ToolbarService;
import com.spin.domain.SpinSoftwareVersion;
import com.spin.util.ExhibitionMode;
import com.spin.util.ReadPOM;
import com.spin.util.URSimUtil;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarService;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(@NotNull BundleContext context) {
        URSimUtil.configureLogging();
        SpinLog.print("Starting URCap");
        Map<String, String> map = Objects.requireNonNull(ReadPOM.parseProjectToMap("META-INF/maven/com.spin/SpinRobotics/pom.xml"));
        String thisVersion = map.get("version");
        if (thisVersion == null) {
            throw new RuntimeException("Could not read version from pom.xml");
        }
        SpinSoftwareVersion.setThisURCapVersion(SpinSoftwareVersion.parse(thisVersion));
        Map<String, String> propMap = Objects.requireNonNull(ReadPOM.parsePropertiesToMap("META-INF/maven/com.spin/SpinRobotics/pom.xml"));
        String minBridgeVersion = propMap.get("minimumBridgeVersion");
        if (minBridgeVersion == null) {
            throw new RuntimeException("Could not read version from pom.xml");
        }
        SpinSoftwareVersion.setMinimumBridgeVersion(SpinSoftwareVersion.parse(minBridgeVersion));
        BridgeProxyFactoryImpl bridgeProxyFactory = new BridgeProxyFactoryImpl(new ConnectionFactory());
        context.registerService(SwingInstallationNodeService.class, (Object)new InstallationService(bridgeProxyFactory), null);
        context.registerService(SwingProgramNodeService.class, (Object)new ScrewdrivingSetupService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new AttachBitService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new DetachBitService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new ToolActionService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new LoadScrewService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new DriveScrewService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new OnOkService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new OnNotOkService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new OnFaultService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new MoveAwayService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new ApproachService(), null);
        context.registerService(SwingProgramNodeService.class, (Object)new SafeApproachService(), null);
        context.registerService(SwingToolbarService.class, (Object)new ToolbarService(), null);
        if (ExhibitionMode.isEnabled()) {
            context.registerService(SwingProgramNodeService.class, (Object)new UnloadScrewService(), null);
            context.registerService(SwingProgramNodeService.class, (Object)new MoveToScrewService(), null);
        }
    }

    public void stop(@NotNull BundleContext bundleContext) {
    }
}

