/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.screwdriving_setup.on_success;

import com.spin.api.ExtendedProgramAPIProvider;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionInterface;
import com.spin.core.program_node.hidden_nodes.move_direction.MoveDirectionService;
import com.spin.core.program_node.screwdriving_setup.on_success.OnSuccessInterface;
import com.spin.core.program_node.screwdriving_setup.on_success.OnSuccessText;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.value.simple.Length;
import org.jetbrains.annotations.NotNull;

public class OnSuccessContribution
implements ProgramNodeContribution,
OnSuccessInterface {
    private final ExtendedProgramAPIProvider apiProvider;

    public OnSuccessContribution(@NotNull ExtendedProgramAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
        ProgramModel programModel = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel();
        TreeNode root = programModel.getRootTreeNode((ProgramNodeContribution)this);
        try {
            URCapProgramNode moveNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory().createURCapProgramNode(MoveDirectionService.class);
            root.addChild((ProgramNode)moveNode);
            ((MoveDirectionInterface)moveNode.getAs(MoveDirectionInterface.class)).setMoveDistance(apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getSimpleValueFactory().createLength(50.0, Length.Unit.MM));
            URCapProgramNode toolActionNode = apiProvider.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory().createURCapProgramNode(ToolActionService.class);
            root.addChild((ProgramNode)toolActionNode);
            ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
        }
        catch (TreeStructureException e) {
            e.printStackTrace();
        }
    }

    public void openView() {
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.apiProvider.getTextResource().load(OnSuccessText.ON_SUCCESS);
    }

    public boolean isDefined() {
        return true;
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        writer.appendLine("if (screw_status == 2) :");
        writer.appendLine("sync()");
        writer.writeChildren();
    }

    @Override
    public void writeTheScript(@NotNull ScriptWriter writer) {
        this.generateScript(writer);
    }
}

