/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.unload_screw;

import com.spin.api.ExtendedViewAPIProvider;
import com.spin.core.program_node.unload_screw.UnloadScrewContribution;
import com.spin.core.program_node.unload_screw.UnloadScrewText;
import com.spin.core.program_node.unload_screw.VerifyPositionView;
import com.spin.domain.ScrewFeeder;
import com.spin.i18n.TextResource;
import com.spin.ui.callback.OnOkPositionCallback;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.ButtonMedium;
import com.spin.ui.component.CheckBox;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.value.Pose;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnloadScrewView
implements SwingProgramNodeView<UnloadScrewContribution> {
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final JPanel verifyPositionPanel;
    @NotNull
    private final VerifyPositionView verifyPositionView;
    @NotNull
    private final ImagePanel logo;
    @NotNull
    private final ComboBox<ScrewFeeder> screwFeederSelector;
    @NotNull
    private final Label setupMissingLabel;
    @NotNull
    private final CheckBox approachCheckBox;
    @NotNull
    private final MessageBoxSmall approachWarning;
    @NotNull
    private final CheckBox departureCheckBox;
    @NotNull
    private final MessageBoxSmall departureWarning;
    @NotNull
    private final JPanel approachAndDeparturePanel;
    @NotNull
    private final ButtonMedium verifyPositionButton;
    @NotNull
    private final ButtonMedium teachPositionButton;
    @NotNull
    private final String teachPositionText;
    @NotNull
    private final String reteachPositionText;
    @NotNull
    private final String verifyPositionText;
    @Nullable
    private Pose definedPose = null;

    UnloadScrewView(ExtendedViewAPIProvider extendedViewAPIProvider) {
        TextResource textResource = extendedViewAPIProvider.getTextResource();
        this.logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        this.setupMissingLabel = new Label(textResource.load(UnloadScrewText.MISSING_SETUP), UR_Icon.WARNING_SMALL.load(), 2);
        this.screwFeederSelector = new ComboBox();
        this.screwFeederSelector.setDefaultText(textResource.load(UnloadScrewText.NONE));
        this.approachCheckBox = new CheckBox(textResource.load(UnloadScrewText.APPROACH_ENABLE));
        this.approachWarning = new MessageBoxSmall(textResource.load(UnloadScrewText.APPROACH_WARNING), AbstractMessageBox.Type.WARNING);
        this.departureCheckBox = new CheckBox(textResource.load(UnloadScrewText.DEPART_ENABLE));
        this.departureWarning = new MessageBoxSmall(textResource.load(UnloadScrewText.DEPART_WARNING), AbstractMessageBox.Type.WARNING);
        this.approachAndDeparturePanel = new JPanel();
        this.approachAndDeparturePanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[][][][]"));
        this.approachAndDeparturePanel.add((Component)this.approachCheckBox, "cell 0 0");
        this.approachAndDeparturePanel.add((Component)this.approachWarning, "cell 0 1, span 12, left, hidemode 3");
        this.approachAndDeparturePanel.add((Component)this.departureCheckBox, "cell 0 2");
        this.approachAndDeparturePanel.add((Component)this.departureWarning, "cell 0 3, span 12, left, hidemode 3");
        this.teachPositionText = textResource.load(UnloadScrewText.TEACH_POSITION);
        this.reteachPositionText = textResource.load(UnloadScrewText.RETEACH_POSITION);
        this.verifyPositionText = textResource.load(UnloadScrewText.VERIFY_POSITION);
        this.teachPositionButton = new ButtonMedium(this.teachPositionText, UR_Icon.MOVE_TEACH.load());
        this.setButtonStyleAsTeach();
        this.verifyPositionButton = new ButtonMedium(this.verifyPositionText, UR_Icon.WIZARD.load());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[top][][][][]push[]"));
        this.mainPanel.add(this.screwFeederSelector, "cell 0 0, span 7, grow");
        this.mainPanel.add((Component)this.teachPositionButton, "cell 0 1, span 5, grow");
        this.mainPanel.add((Component)this.verifyPositionButton, "cell 0 2, span 5, grow");
        this.mainPanel.add((Component)this.setupMissingLabel, "cell 0 3, span 7, hidemode 3");
        this.mainPanel.add((Component)this.approachAndDeparturePanel, "cell 0 4, span 12 1, growx, hidemode 3");
        this.mainPanel.add((Component)this.logo, "cell 0 5, span 4 2");
        this.verifyPositionView = new VerifyPositionView(extendedViewAPIProvider);
        this.verifyPositionPanel = this.verifyPositionView.createPanel();
        this.verifyPositionPanel.setVisible(false);
    }

    public void buildUI(JPanel panel, ContributionProvider<UnloadScrewContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[grow]"));
        panel.add((Component)this.mainPanel, "grow, hidemode 3");
        panel.add((Component)this.verifyPositionPanel, "grow, hidemode 3");
        this.registerListeners(provider);
    }

    private void registerListeners(@NotNull ContributionProvider<UnloadScrewContribution> provider) {
        ActionListener comboBoxListener = e -> {
            ScrewFeeder selectedFeeder = (ScrewFeeder)this.screwFeederSelector.getSelectedItem();
            if (selectedFeeder != null) {
                ((UnloadScrewContribution)provider.get()).selectScrewFeeder(selectedFeeder);
            }
        };
        this.screwFeederSelector.addActionListener(comboBoxListener);
        this.approachCheckBox.addActionListener(event -> {
            boolean enabled = this.approachCheckBox.isSelected();
            ((UnloadScrewContribution)provider.get()).setApproachEnabled(enabled);
            this.approachWarning.setVisible(!enabled);
        });
        this.departureCheckBox.addActionListener(event -> {
            boolean enabled = this.departureCheckBox.isSelected();
            ((UnloadScrewContribution)provider.get()).setDepartEnabled(enabled);
            this.departureWarning.setVisible(!enabled);
        });
        this.teachPositionButton.addActionListener(event -> this.getUserDefinedPosition((UnloadScrewContribution)provider.get()));
        this.verifyPositionButton.addActionListener(event -> {
            this.toggleActivePanel();
            this.verifyPositionView.resetWithPoses(((UnloadScrewContribution)provider.get()).poseAbove(), ((UnloadScrewContribution)provider.get()).pose());
        });
        this.verifyPositionView.registerListeners(provider);
    }

    public void toggleActivePanel() {
        this.mainPanel.setVisible(!this.mainPanel.isVisible());
        this.verifyPositionPanel.setVisible(!this.verifyPositionPanel.isVisible());
    }

    public void setScrewFeeders(Set<ScrewFeeder> screwFeeders) {
        this.screwFeederSelector.runWithoutFiringActionsEvents(() -> {
            this.screwFeederSelector.removeAllItems();
            screwFeeders.stream().sorted(Comparator.comparing(feeder -> feeder.name().toLowerCase()).thenComparing(ScrewFeeder::name)).forEach(this.screwFeederSelector::addItem);
        });
        this.setupMissingLabel.setVisible(screwFeeders.isEmpty());
    }

    void setApproachEnabled(boolean enabled) {
        this.approachCheckBox.setSelected(enabled);
        this.approachWarning.setVisible(!enabled);
    }

    void setDepartEnabled(boolean enabled) {
        this.departureCheckBox.setSelected(enabled);
        this.departureWarning.setVisible(!enabled);
    }

    void setButtonStyleAsTeach() {
        this.teachPositionButton.enableCallToActionStyle(true);
        this.teachPositionButton.setText(this.teachPositionText);
    }

    void setButtonStyleAsReteach() {
        this.teachPositionButton.enableCallToActionStyle(false);
        this.teachPositionButton.setText(this.reteachPositionText);
    }

    void selectedScrewFeeder(@Nullable ScrewFeeder screwFeeder) {
        this.screwFeederSelector.setSelectedItem(screwFeeder);
    }

    private void getUserDefinedPosition(@NotNull UnloadScrewContribution contribution) {
        contribution.getUserInteraction().getUserDefinedRobotPosition((RobotPositionCallback2)new OnOkPositionCallback(parameters -> {
            contribution.setPose(parameters.getPose());
            this.setButtonStyleAsReteach();
            this.verifyPositionButton.setEnabled(true);
        }));
    }

    public void setCallToAction(Pose pose) {
        if (pose == null) {
            this.setButtonStyleAsTeach();
        } else {
            this.setButtonStyleAsReteach();
        }
    }
}

