/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node.bit_change;

import com.spin.urcap.impl.installation_node.bit_change.BitChangeTabView;
import com.spin.urcap.impl.localization.CommandNamesResource;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.util.PopupTool;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.UserInterfaceAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.feature.FeatureContributionModel;
import com.ur.urcap.api.domain.userinteraction.RobotPositionCallback2;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.robotposition.PositionParameters;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class BitChangeTabContribution {
    private static final String KEY_POINT_A = "KEY_POINT_A";
    private static final String KEY_POINT_B = "KEY_POINT_B";
    private static final String KEY_POINT_C = "KEY_POINT_C";
    public final PoseFactory poseFactory;
    private final InstallationAPIProvider apiProvider;
    private final BitChangeTabView bitChangeTabView;
    private final LanguagePack languagePack;
    private final UserInterfaceAPI userInterfaceAPI;
    private final DataModel model;
    private final FeatureContributionModel featureContributionModel;
    private Timer uiTimer;

    public BitChangeTabContribution(InstallationAPIProvider apiProvider, BitChangeTabView bitChangeTabView, DataModel model, CreationContext context) {
        this.apiProvider = apiProvider;
        this.userInterfaceAPI = apiProvider.getUserInterfaceAPI();
        this.poseFactory = apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory();
        this.bitChangeTabView = bitChangeTabView;
        this.languagePack = new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization());
        this.model = model;
        this.featureContributionModel = apiProvider.getInstallationAPI().getFeatureContributionModel();
        if (context.getNodeCreationType() == CreationContext.NodeCreationType.LOAD) {
            this.generateFeatureFromDataModel(true);
        }
    }

    public void initDataModel() {
    }

    public String NodeTitle() {
        return this.getCommandNamesResource().nodeTabMountingInstallation();
    }

    public void openView() {
        this.bitChangeTabView.setMoveBtnEnabled(this.featureContributionModel.getFeature("KEY_FEATURE") != null);
        this.bitChangeTabView.setTeachIcon("A");
        if (this.featureContributionModel.getFeature("KEY_FEATURE") != null) {
            this.bitChangeTabView.setMoveBtnEnabled(true);
        }
        this.uiTimer = new Timer(true);
        this.uiTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BitChangeTabContribution.this.updateUI();
                    }
                });
            }
        }, 0L, 1000L);
    }

    public void closeView() {
        if (this.uiTimer != null) {
            this.uiTimer.cancel();
        }
    }

    public void updateUI() {
        this.bitChangeTabView.setApproveLabelAVisible(this.model.isSet(KEY_POINT_A));
        this.bitChangeTabView.setApproveLabelBVisible(this.model.isSet(KEY_POINT_B));
        this.bitChangeTabView.setApproveLabelCVisible(this.model.isSet(KEY_POINT_C));
        if (this.featureContributionModel.getFeature("KEY_FEATURE") == null) {
            this.bitChangeTabView.setTeachPointBButtonEnabled(this.model.isSet(KEY_POINT_A));
            this.bitChangeTabView.setTeachPointCButtonEnabled(this.model.isSet(KEY_POINT_B));
        } else {
            this.bitChangeTabView.setTeachPointBButtonEnabled(false);
            this.bitChangeTabView.setTeachPointCButtonEnabled(false);
        }
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    private CommandNamesResource getCommandNamesResource() {
        return this.languagePack.getCommandNamesResource();
    }

    public String getTitleText() {
        return this.getTextResource().titleInstallationMounting();
    }

    public String getInfoText() {
        return this.getTextResource().infoTextInstallationMounting();
    }

    public String getMoveToFeatureText() {
        return this.getTextResource().installationMountingMoveToFeatureButton();
    }

    public String getTeachAText() {
        return this.getTextResource().installationMountingTeachA();
    }

    public String getTeachBText() {
        return this.getTextResource().installationMountingTeachB();
    }

    public String getTeachCText() {
        return this.getTextResource().installationMountingTeachC();
    }

    public String getTeachTitleText() {
        return this.getTextResource().installationMountingTeachTitle();
    }

    public Pose generatePoseFromPoints(Vector3D origo, Vector3D point_x_axis, Vector3D point_y_axis) {
        Vector3D x_axis = point_x_axis.subtract((Vector)origo);
        Vector3D y_axis = point_y_axis.subtract((Vector)origo);
        Vector3D z_axis = x_axis.crossProduct((Vector)y_axis);
        y_axis = z_axis.crossProduct((Vector)x_axis);
        x_axis = x_axis.normalize();
        y_axis = y_axis.normalize();
        z_axis = z_axis.normalize();
        double[][] rotMat = new double[][]{{x_axis.getX(), x_axis.getY(), x_axis.getZ()}, {y_axis.getX(), y_axis.getY(), y_axis.getZ()}, {z_axis.getX(), z_axis.getY(), z_axis.getZ()}};
        Rotation rot = new Rotation((double[][])rotMat, 1.0E-10);
        Rotation r = this.rotateAroundY(rot, 3.14);
        Vector3D rotvec = r.getAxis(RotationConvention.FRAME_TRANSFORM).scalarMultiply(r.getAngle());
        return this.apiProvider.getInstallationAPI().getValueFactoryProvider().getPoseFactory().createPose(origo.getX(), origo.getY(), origo.getZ(), rotvec.getX(), rotvec.getY(), rotvec.getZ(), Length.Unit.M, Angle.Unit.RAD);
    }

    private Rotation rotateAroundY(Rotation R, double rotation) {
        double[][] rotMat = new double[][]{{Math.cos(rotation), 0.0, Math.sin(rotation)}, {0.0, 1.0, 0.0}, {-Math.sin(rotation), 0.0, Math.cos(rotation)}};
        return new Rotation((double[][])rotMat, 1.0E-10).applyTo(R);
    }

    public Pose getSpinBitChangeFeature() {
        return this.featureContributionModel.getFeature("KEY_FEATURE").getPose();
    }

    public InstallationAPIProvider getApiProvider() {
        return this.apiProvider;
    }

    public void setPointA() {
        this.setPoseWithKey(KEY_POINT_A);
    }

    public void setPointB() {
        this.setPoseWithKey(KEY_POINT_B);
    }

    public void setPointC() {
        this.setPoseWithKey(KEY_POINT_C);
    }

    public Pose getPointA() {
        return this.model.get(KEY_POINT_A, (Pose)null);
    }

    public Pose getPointB() {
        return this.model.get(KEY_POINT_B, (Pose)null);
    }

    public Pose getPointC() {
        return this.model.get(KEY_POINT_C, (Pose)null);
    }

    public boolean featureIsSet() {
        return this.featureContributionModel.getFeature("KEY_FEATURE") != null;
    }

    public void setPoseWithKey(final String key) {
        this.userInterfaceAPI.getUserInteraction().getUserDefinedRobotPosition(new RobotPositionCallback2(){

            public void onOk(PositionParameters parameters) {
                BitChangeTabContribution.this.model.set(key, parameters.getPose());
                BitChangeTabContribution.this.generateFeatureFromDataModel(false);
            }
        });
    }

    public void removePoints() {
        this.model.remove(KEY_POINT_A);
        this.model.remove(KEY_POINT_B);
        this.model.remove(KEY_POINT_C);
    }

    public void removeFeature() {
        if (this.featureContributionModel.getFeature("KEY_FEATURE") != null) {
            this.featureContributionModel.removeFeature("KEY_FEATURE");
        }
        this.bitChangeTabView.setMoveBtnEnabled(false);
    }

    public void generateFeatureFromDataModel(boolean onStartUp) {
        Pose A = this.getPointA();
        Pose B = this.getPointB();
        Pose C = this.getPointC();
        if (A != null && B != null && C != null) {
            Vector3D x_axis;
            Vector3D y_axis;
            Position PosA = A.getPosition();
            Position PosB = B.getPosition();
            Position PosC = C.getPosition();
            Vector3D origo = new Vector3D(PosB.getX(Length.Unit.M), PosB.getY(Length.Unit.M), PosB.getZ(Length.Unit.M));
            Vector3D[] vectors = this.calculatePoints(new Vector3D[]{origo, y_axis = new Vector3D(PosA.getX(Length.Unit.M), PosA.getY(Length.Unit.M), PosA.getZ(Length.Unit.M)), x_axis = new Vector3D(PosC.getX(Length.Unit.M), PosC.getY(Length.Unit.M), PosC.getZ(Length.Unit.M))});
            if ((vectors[0].distance((Vector)vectors[1]) < 0.04 || vectors[0].distance((Vector)vectors[1]) > 0.05 || vectors[0].distance((Vector)vectors[2]) < 0.125 || vectors[0].distance((Vector)vectors[2]) > 0.135) && !onStartUp) {
                PopupTool.showDialogWarning(this.getTextResource().installationMountingPointDistanceWarning(), this.getTextResource().installationMountingPointDistanceWarningTitle(), new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
                this.removePoints();
                return;
            }
            Pose pose = this.generatePoseFromPoints(vectors[0], vectors[2], vectors[1]);
            if (this.featureContributionModel.getFeature("KEY_FEATURE") == null) {
                this.featureContributionModel.addFeature("KEY_FEATURE", "SpinBitChanger", pose);
            } else {
                this.featureContributionModel.updateFeature("KEY_FEATURE", pose);
            }
            if (!onStartUp) {
                PopupTool.showDialogInformation(this.getTextResource().installationBitChangerSetupSuccessful(), this.getTextResource().installationBitChangerSetupSuccessfulTitle());
                this.bitChangeTabView.setMoveBtnEnabled(true);
            }
        }
    }

    private Vector3D[] calculatePoints(Vector3D[] vectors) {
        Double[] distances = new Double[]{vectors[0].distance((Vector)vectors[1]) + vectors[0].distance((Vector)vectors[2]), vectors[1].distance((Vector)vectors[0]) + vectors[1].distance((Vector)vectors[2]), vectors[2].distance((Vector)vectors[0]) + vectors[2].distance((Vector)vectors[1])};
        Object[] sortedDistances = new Double[]{distances[0], distances[1], distances[2]};
        Arrays.sort(sortedDistances);
        Vector3D[] result = new Vector3D[]{null, null, null};
        for (int i = 0; i < sortedDistances.length; ++i) {
            for (int j = 0; j < distances.length; ++j) {
                if (sortedDistances[i] != distances[j]) continue;
                result[i] = vectors[j];
            }
        }
        return result;
    }
}

