/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.xmlrpc;

import com.spin.urcap.impl.daemons.communicator.IOHandler;
import com.spin.urcap.impl.daemons.xmlrpc.ToolStatusCallbacks;
import com.spin.urcap.impl.daemons.xmlrpc.ToolStatusTask;
import com.spin.urcap.impl.daemons.xmlrpc.WatchdogTask;
import com.spin.urcap.impl.installation_node.Stoppable;
import com.ur.urcap.api.domain.io.IOModel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tool2
implements ToolStatusCallbacks,
Stoppable {
    private static final int CDO_HEARTBEAT = 6;
    private static final int CDO_FREEDRIVE = 7;
    private static final long TOOL_STATUS_TASK_PERIOD_MS = 50L;
    private final AtomicBoolean toolConnected;
    private final ToolStatusTask toolStatusTask;
    private static final long bridgeWatchdogTimeout = 2L;
    private final WatchdogTask watchdogTask = new WatchdogTask(2L, TimeUnit.SECONDS, this);
    private final IOHandler ioHandler;
    private static final ScheduledExecutorService toolStatusTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private static final ExecutorService watchdogTaskExecutor = Executors.newSingleThreadExecutor();

    public Tool2(IOModel ioModel) {
        this.ioHandler = new IOHandler(ioModel);
        this.toolStatusTask = new ToolStatusTask(this);
        this.toolConnected = new AtomicBoolean(false);
        long initialDelayMillis = 0L;
        toolStatusTaskExecutor.scheduleAtFixedRate(this.toolStatusTask, initialDelayMillis, 50L, TimeUnit.MILLISECONDS);
        watchdogTaskExecutor.execute(this.watchdogTask);
    }

    public boolean isToolConnected() {
        return this.toolConnected.get();
    }

    public boolean isBridgeConnected() {
        return this.watchdogTask.isAlive();
    }

    @Override
    public void heartbeatCallback(boolean heartbeat) {
        this.ioHandler.setConfigOut(6, heartbeat);
        this.watchdogTask.setHeartbeat(heartbeat);
    }

    @Override
    public void freedriveCallback(boolean freedriveEnabled) {
        boolean freedriveOutputStatus = this.ioHandler.getConfigOut(7);
        if (freedriveOutputStatus != freedriveEnabled) {
            this.ioHandler.setConfigOut(7, freedriveEnabled);
        }
    }

    @Override
    public void toolConnectedCallback(boolean toolConnected) {
        boolean updated = this.toolConnected.compareAndSet(!toolConnected, toolConnected);
        if (updated) {
            // empty if block
        }
    }

    @Override
    public void watchdogJustDied() {
        this.toolConnectedCallback(false);
        this.freedriveCallback(false);
    }

    @Override
    public void watchdogWokeUp() {
    }

    @Override
    public void stop() {
        toolStatusTaskExecutor.shutdownNow();
        watchdogTaskExecutor.shutdownNow();
    }
}

