/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.xmlrpc;

import com.spin.urcap.impl.daemons.xmlrpc.ToolStatusCallbacks;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class WatchdogTask
implements Runnable {
    private final ToolStatusCallbacks callbacks;
    private final BlockingQueue<Boolean> watchdogFood = new LinkedBlockingQueue<Boolean>();
    private boolean lastHeartbeat;
    private long lastHeartbeatTime = 0L;
    private final long timeout;
    private final TimeUnit unit;
    private final AtomicBoolean isAlive;

    public WatchdogTask(long timeout, TimeUnit unit, ToolStatusCallbacks callbacks) {
        this.timeout = timeout;
        this.unit = unit;
        this.isAlive = new AtomicBoolean(false);
        this.callbacks = callbacks;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Spin" + this.getClass().getSimpleName());
        try {
            while (!Thread.currentThread().isInterrupted()) {
                boolean updated;
                if (this.watchdogFood.poll(this.timeout, this.unit) != null || !(updated = this.isAlive.compareAndSet(true, false))) continue;
                this.callbacks.watchdogJustDied();
                System.out.println(this.getClass().getSimpleName() + ": Just died!");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.out.println(Thread.currentThread().getName() + ": interrupted.");
        }
    }

    private void checkHeartbeatPeriod(long expectedPeriodMillis) {
        long warningThreshold;
        long now = System.currentTimeMillis();
        long actualPeriod = now - this.lastHeartbeatTime;
        if (actualPeriod > (warningThreshold = 2L * expectedPeriodMillis)) {
            System.out.println(this.getClass().getSimpleName() + ": Warning heartbeat duration. Expected: " + expectedPeriodMillis + " - actual: " + actualPeriod + " ms");
        }
        this.lastHeartbeatTime = now;
    }

    private void feed() {
        this.watchdogFood.add(true);
        this.checkHeartbeatPeriod(200L);
        boolean updated = this.isAlive.compareAndSet(false, true);
        if (updated) {
            System.out.println(this.getClass().getSimpleName() + ": Woke up!");
            this.callbacks.watchdogWokeUp();
        }
    }

    public void setHeartbeat(boolean heartbeat) {
        if (this.lastHeartbeat != heartbeat) {
            this.feed();
            this.lastHeartbeat = heartbeat;
        }
    }

    public boolean isAlive() {
        return this.isAlive.get();
    }
}

