/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.communicator;

import com.spin.urcap.impl.daemons.communicator.ScriptCommand;
import com.spin.urcap.impl.daemons.communicator.ScriptExporter;
import com.spin.urcap.impl.daemons.communicator.ScriptTypeConverter;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import java.util.List;

public class ScriptProxy
extends ScriptExporter {
    final ScriptTypeConverter type;
    final String COMMAND = "cmd";
    final String TEMP_VALUE = "temp_value";
    final String RETURN_VALUE = "return_value";
    final String ASSIGN_STRING = "temp_value=";

    public ScriptProxy(ScriptTypeConverter type) {
        this.type = type;
    }

    public ScriptProxy(PoseFactory poseFactory) {
        this.type = new ScriptTypeConverter(poseFactory);
    }

    private String buildSendAndReceive(ScriptCommand command) {
        command.appendLine("return_value=to_str(temp_value)");
        ScriptCommand newCommand = this.buildScriptCommandToExport(command, "return_value");
        return this.readValueFromRobot(newCommand);
    }

    private void buildSend(ScriptCommand command) {
        command.appendLine("return_value=0");
        ScriptCommand newCommand = this.buildScriptCommandToExport(command, "return_value");
        this.readValueFromRobot(newCommand);
    }

    public Double acos(Double f) {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=acos(" + this.type.doubleToScript(f) + ")");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToDouble(reply);
    }

    public Boolean get_configurable_digital_in(Integer n) {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=get_configurable_digital_in(" + this.type.integerToScript(n) + ")");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToBoolean(reply);
    }

    public Boolean get_configurable_digital_out(Integer n) {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=get_configurable_digital_out(" + this.type.integerToScript(n) + ")");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToBoolean(reply);
    }

    public int read_output_integer_register(int n) {
        System.out.println("read_output_integer_register()");
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=read_output_integer_register(" + this.type.integerToScript(n) + ")");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToInteger(reply);
    }

    public void set_configurable_digital_out(Integer n, Boolean b) {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("set_configurable_digital_out(" + this.type.integerToScript(n) + "," + this.type.booleanToScript(b) + ")");
        this.buildSend(command);
    }

    public void set_digital_out(Integer n, Boolean b) {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("set_digital_out(" + this.type.integerToScript(n) + "," + this.type.booleanToScript(b) + ")");
        this.buildSend(command);
    }

    public Double force() {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=force()");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToDouble(reply);
    }

    public Pose get_actual_tcp_pose() {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=get_actual_tcp_pose()");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToPose(reply);
    }

    public List<Double> get_joint_torques() {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=get_joint_torques()");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToDoubleList(reply);
    }

    public void end_freedrive_mode() {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("end_freedrive_mode()");
        command.setAsSecondaryProgram();
        this.buildSend(command);
    }

    public void freedrive_mode() {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("freedrive_mode()");
        command.setAsSecondaryProgram();
        this.buildSend(command);
    }

    public Pose pose_inv(Pose p_from) {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=pose_inv(" + this.type.poseToScript(p_from) + ")");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToPose(reply);
    }

    public Pose pose_trans(Pose p_from, Pose p_from_to) {
        ScriptCommand command = new ScriptCommand("cmd");
        command.appendLine("temp_value=pose_trans(" + this.type.poseToScript(p_from) + "," + this.type.poseToScript(p_from_to) + ")");
        String reply = this.buildSendAndReceive(command);
        return this.type.scriptToPose(reply);
    }
}

