/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes.toolbar;

import com.spin.urcap.impl.daemons.xmlrpc.XMLRPCClient;
import com.spin.urcap.impl.installation_node.InstallationContribution;
import com.spin.urcap.impl.installation_node.Stoppable;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.util.ScrewProgramLog;
import com.spin.urcap.impl.util.swing.SwingAbstractStyle;
import com.spin.urcap.impl.util.swing.SwingStandards;
import com.spin.urcap.impl.util.swing.SwingV3Style;
import com.spin.urcap.impl.util.swing.SwingV5Style;
import com.ur.urcap.api.contribution.toolbar.ToolbarAPIProvider;
import com.ur.urcap.api.contribution.toolbar.ToolbarContext;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarContribution;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GuideToolbarContribution
implements SwingToolbarContribution,
Stoppable {
    private static final double M_TO_MM = 1000.0;
    private static final int COLUMN_COUNT = 4;
    private static final String[] stepperCommands = new String[]{"0: Stop", "5: Home", "10: Move home", "11: Move bit release", "12: Move bit cover", "30: Run downwards", "31: Run upwards", "40: Robot follow"};
    private static final Dimension BUTTON_DIMENSION = new Dimension(150, 40);
    private static Timer uiTimer;
    private static final int ROW_COUNT = 10;
    private int screwProgramLogIdOld = -1;
    private final KeyboardTextInput keyboardFactoryIp;
    private Timer connectionTimer;
    private JTable logTable;
    private JToggleButton ftFreeRunningBtn;
    private JToggleButton ftFreeRunDirectionBtn;
    private JButton btnDoHoming;
    private JButton btnMoveBitRelease;
    private JButton btnMoveBitLock;
    private JButton btnReturn;
    private JComboBox shieldCB;
    private JLabel lblConnIcon;
    private JLabel lblConnBridgeIcon;
    private JLabel lblSpeed;
    private JLabel lblToolCnt;
    private JLabel lblBridgeCnt;
    private double _sliderSpeed = 50.0;
    private String _shieldCBState = stepperCommands[0];
    private final JTextField defaultIp = new JTextField();
    private boolean motorRunning;
    private JTableHeader logTableHeader = new JTableHeader();
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private int rowCount = -1;
    private Component ipComponent;
    private Component cbShield;
    private Component btnShield;
    private final SwingAbstractStyle style;
    private final SpinGraphRow[] spinGraphArray = new SpinGraphRow[10];
    private int freerunDirection = 0;
    private ToolbarAPIProvider apiProvider;
    private String settingsIp;
    private static boolean newConnection;

    GuideToolbarContribution(ToolbarContext context) {
        this.style = context.getAPIProvider().getSystemAPI().getSoftwareVersion().getMajorVersion() >= 5 ? new SwingV5Style() : new SwingV3Style();
        context.getAPIProvider().getApplicationAPI().getFeatureModel().getGeomFeatures();
        this.keyboardFactoryIp = context.getAPIProvider().getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createStringKeyboardInput();
        this.apiProvider = context.getAPIProvider();
    }

    public GuideToolbarContribution() {
        this.style = null;
        this.keyboardFactoryIp = null;
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    public void openView() {
        this.showDebug(false);
        this.lblSpeed.setText(this.getTextResource().toolbarMotorSpeed());
        this.lblToolCnt.setText(this.getTextResource().toolbarConnectTool());
        this.lblBridgeCnt.setText(this.getTextResource().toolbarConnectBridge());
        this.ftFreeRunningBtn.setText(this.getTextResource().toolbarFreerun());
        this.updateSettingsIp();
        this.defaultIp.setText(this.settingsIp == null ? this.defaultIp.getText() : this.settingsIp);
        this.connectionTimer = new Timer(true);
        this.connectionTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    GuideToolbarContribution.this.setBridgeConnection(GuideToolbarContribution.this.isBridgeConnected());
                    GuideToolbarContribution.this.setToolConnection(GuideToolbarContribution.this.isToolConnected());
                }
                catch (Exception e) {
                    GuideToolbarContribution.this.setConnection(false, false);
                    e.printStackTrace();
                }
            }
        }, 0L, 2500L);
    }

    private void setBridgeConnection(boolean connected) {
        this.lblConnBridgeIcon.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource(connected ? "/com/spin/urcap/icons/UR_e-Series_1.0/approve_small.png" : "/com/spin/urcap/icons/UR_e-Series_1.0/cancel_small.png"))));
    }

    private void setToolConnection(boolean connected) {
        this.lblConnIcon.setIcon(new ImageIcon(Objects.requireNonNull(this.getClass().getResource(connected ? "/com/spin/urcap/icons/UR_e-Series_1.0/approve_small.png" : "/com/spin/urcap/icons/UR_e-Series_1.0/cancel_small.png"))));
        this.setBtnsEnabled(connected);
    }

    private void setConnection(boolean bridge, boolean tool) {
        this.setBridgeConnection(bridge);
        this.setToolConnection(tool);
        this.setBtnsEnabled(tool);
    }

    public void setNewConnection(boolean value) {
        newConnection = value;
    }

    public void closeView() {
        this.btnReturn.setVisible(false);
        this.chartPanel.setVisible(false);
        this.logTableHeader.setVisible(true);
        this.logTable.setVisible(true);
        if (this.connectionTimer != null) {
            this.connectionTimer.cancel();
        }
    }

    public void stopTimer() {
        uiTimer.cancel();
    }

    public void buildUI(JPanel jPanel) {
        JPanel mainPanel = new JPanel();
        GroupLayout layout = new GroupLayout(mainPanel);
        mainPanel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        Component slider = this.CreateSlider();
        Component btnC = this.createFreeRunBtn();
        this.createFreerunDirectionBtn();
        this.cbShield = this.createShieldComboBox();
        this.btnShield = this.createShieldButton();
        Component btnErrorReset = this.createErrorResetButton();
        Component btnDoHoming = this.createBtnDoHoming();
        Component btnLockBit = this.createBtnMoveBitLock();
        Component btnBitRelease = this.createBtnMoveBitRelease();
        this.lblConnIcon = this.createConnectedIcon();
        this.lblConnBridgeIcon = this.createConnectedBridgeIcon();
        JLabel lblConnSeparator = SwingStandards.createLabel("|", true, true, new Dimension(10, 21), this.style.getURFontSizeVeryLarge() + 6);
        this.lblToolCnt = SwingStandards.createLabel(this.getTextResource().toolbarConnectTool(), true, true, new Dimension(100, 25), this.style.getURFontSizeVeryLarge());
        this.lblBridgeCnt = SwingStandards.createLabel(this.getTextResource().toolbarConnectBridge(), true, true, new Dimension(100, 25), this.style.getURFontSizeVeryLarge());
        this.lblSpeed = SwingStandards.createLabel(this.getTextResource().toolbarMotorSpeed(), true, false, this.style.getLabelSize(), this.style.getURFontSizeVeryLarge());
        this.defaultIp.setText("192.168.37.1");
        this.createTable();
        this.createReturnBtn();
        this.ipComponent = this.createLabelInputTextField(this.defaultIp, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KeyboardTextInput keyboardTextInput = GuideToolbarContribution.this.getKeyboardForIp();
                keyboardTextInput.show(GuideToolbarContribution.this.defaultIp, GuideToolbarContribution.this.getCallbackForIp());
            }
        });
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(new Dimension(500, 175));
        this.chartPanel.setMaximumSize(this.chartPanel.getPreferredSize());
        this.chartPanel.setBackground(Color.WHITE);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addComponent(this.lblBridgeCnt, -2, -2, -2).addComponent(this.lblConnBridgeIcon, -2, -2, -2)).addComponent(lblConnSeparator, -2, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.lblToolCnt, -2, -2, -2).addComponent(this.lblConnIcon, -2, -2, -2))).addGroup(layout.createSequentialGroup().addComponent(btnC, -2, -2, -2).addComponent(this.ftFreeRunDirectionBtn, -2, -2, -2)).addComponent(this.lblSpeed, -2, -2, -2).addComponent(slider, -2, -2, -2).addComponent(this.cbShield, -2, -2, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnShield, -2, -2, -2).addComponent(btnErrorReset, -2, -2, -2)).addComponent(this.ipComponent, -2, -2, -2).addGroup(layout.createSequentialGroup().addComponent(btnBitRelease, -2, -2, -2).addGap(this.style.getHorizontalSmallSpacing()).addComponent(btnLockBit, -2, -2, -2).addGap(this.style.getHorizontalSmallSpacing()).addComponent(btnDoHoming, -2, -2, -2)).addComponent(this.logTableHeader, -2, -2, -2).addComponent(this.logTable, -2, -2, -2).addComponent((Component)this.chartPanel, -2, -2, -2).addComponent(this.btnReturn, -2, -2, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup().addComponent(this.lblBridgeCnt, -2, -2, -2).addComponent(this.lblConnBridgeIcon, -2, -2, -2)).addComponent(lblConnSeparator, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.lblToolCnt, -2, -2, -2).addComponent(this.lblConnIcon, -2, -2, -2))).addGap(this.style.getVerticalSpacing()).addGroup(layout.createParallelGroup().addComponent(btnC, -2, -2, -2).addComponent(this.ftFreeRunDirectionBtn, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.lblSpeed, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(slider, -2, -2, -2).addComponent(this.cbShield, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(this.btnShield, -2, -2, -2).addComponent(btnErrorReset, -2, -2, -2)).addComponent(this.ipComponent, -2, -2, -2).addGroup(layout.createParallelGroup().addComponent(btnBitRelease, -2, -2, -2).addComponent(btnLockBit, -2, -2, -2).addComponent(btnDoHoming, -2, -2, -2)).addGap(this.style.getVerticalSpacing()).addComponent(this.logTableHeader, -2, -2, -2).addComponent(this.logTable, -2, -2, -2).addComponent((Component)this.chartPanel, -2, -2, -2).addComponent(this.btnReturn, -2, -2, -2));
        this.chartPanel.setVisible(false);
        this.btnReturn.setVisible(false);
        jPanel.add(mainPanel);
        uiTimer = new Timer(true);
        uiTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("Spin" + this.getClass().getSimpleName());
                try {
                    int screwProgramLogId = new XMLRPCClient().getScrewProgramLogId();
                    if (newConnection) {
                        GuideToolbarContribution.this.screwProgramLogIdOld = screwProgramLogId;
                        GuideToolbarContribution.this.setNewConnection(false);
                    }
                    if (screwProgramLogId != GuideToolbarContribution.this.screwProgramLogIdOld && screwProgramLogId != -1) {
                        GuideToolbarContribution.this.screwProgramLogIdOld = screwProgramLogId;
                        GuideToolbarContribution.this.addRow();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 0L, 1500L);
    }

    private Component CreateSlider() {
        final JSlider speedSlider = new JSlider();
        speedSlider.setMaximum(100);
        speedSlider.setMinimum(0);
        speedSlider.setMajorTickSpacing(25);
        speedSlider.setMinorTickSpacing(5);
        speedSlider.setPaintTicks(true);
        speedSlider.setPaintLabels(true);
        speedSlider.setValue(50);
        speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!speedSlider.getValueIsAdjusting()) {
                    GuideToolbarContribution.this._sliderSpeed = speedSlider.getValue();
                    if (GuideToolbarContribution.this.motorRunning) {
                        try {
                            XMLRPCClient xmlrpcClient = new XMLRPCClient();
                            double motorMaxSpeedDouble = (double)xmlrpcClient.getTool().motor.maxSpeed / 100.0;
                            xmlrpcClient.setScrewCommand(1, 0, (int)(GuideToolbarContribution.this._sliderSpeed * motorMaxSpeedDouble));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        return speedSlider;
    }

    public Component createFreeRunBtn() {
        this.ftFreeRunningBtn = new JToggleButton(this.getTextResource().toolbarStartFreerun());
        this.ftFreeRunningBtn.setBorder(this.style.getDefaultBtnBoarder());
        this.ftFreeRunningBtn.setBackground(SwingAbstractStyle.URColor.UR_BLUE);
        this.ftFreeRunningBtn.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        this.ftFreeRunningBtn.setMaximumSize(this.ftFreeRunningBtn.getPreferredSize());
        this.ftFreeRunningBtn.setIgnoreRepaint(true);
        this.ftFreeRunningBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XMLRPCClient xmlrpcClient = new XMLRPCClient();
                    if (((JToggleButton)event.getSource()).isSelected()) {
                        GuideToolbarContribution.this.ftFreeRunningBtn.setText(GuideToolbarContribution.this.getTextResource().toolbarStartFreerun());
                        xmlrpcClient.setScrewCommand(0, GuideToolbarContribution.this.freerunDirection, 0);
                        GuideToolbarContribution.this.motorRunning = false;
                        GuideToolbarContribution.this.ftFreeRunDirectionBtn.setEnabled(true);
                    } else {
                        GuideToolbarContribution.this.ftFreeRunningBtn.setText(GuideToolbarContribution.this.getTextResource().toolbarStopFreerun());
                        double motorMaxSpeedDouble = (double)xmlrpcClient.getTool().motor.maxSpeed / 100.0;
                        xmlrpcClient.setScrewCommand(1, GuideToolbarContribution.this.freerunDirection, (int)(GuideToolbarContribution.this._sliderSpeed * motorMaxSpeedDouble));
                        GuideToolbarContribution.this.motorRunning = true;
                        GuideToolbarContribution.this.ftFreeRunDirectionBtn.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.ftFreeRunningBtn.setSelected(true);
        this.ftFreeRunningBtn.setBackground(SwingAbstractStyle.URColor.UR_BLUE);
        return this.ftFreeRunningBtn;
    }

    public void createFreerunDirectionBtn() {
        this.ftFreeRunDirectionBtn = new JToggleButton(this.getTextResource().toolbarClockwise());
        this.ftFreeRunDirectionBtn.setBorder(this.style.getDefaultBtnBoarder());
        this.ftFreeRunDirectionBtn.setBackground(SwingAbstractStyle.URColor.UR_BLUE);
        this.ftFreeRunDirectionBtn.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        this.ftFreeRunDirectionBtn.setMaximumSize(this.ftFreeRunDirectionBtn.getPreferredSize());
        this.ftFreeRunDirectionBtn.setIgnoreRepaint(true);
        this.ftFreeRunDirectionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JToggleButton)e.getSource()).isSelected()) {
                    GuideToolbarContribution.this.ftFreeRunDirectionBtn.setText(GuideToolbarContribution.this.getTextResource().toolbarClockwise());
                    GuideToolbarContribution.this.freerunDirection = 0;
                } else {
                    GuideToolbarContribution.this.ftFreeRunDirectionBtn.setText(GuideToolbarContribution.this.getTextResource().toolbarCounterClockwise());
                    GuideToolbarContribution.this.freerunDirection = 1;
                }
            }
        });
        this.ftFreeRunDirectionBtn.setSelected(true);
    }

    public Component createShieldButton() {
        JButton ftShieldButton = new JButton(this.getTextResource().toolbarMoveShieldBtn());
        ftShieldButton.setBorder(this.style.getDefaultBtnBoarder());
        ftShieldButton.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
        ftShieldButton.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        ftShieldButton.setMaximumSize(ftShieldButton.getPreferredSize());
        ftShieldButton.setIgnoreRepaint(true);
        ftShieldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XMLRPCClient xmlrpcClient = new XMLRPCClient();
                    xmlrpcClient.setSafetyShieldCommand(Integer.parseInt(GuideToolbarContribution.this._shieldCBState.substring(0, GuideToolbarContribution.this._shieldCBState.indexOf(":"))), 0.0, xmlrpcClient.getTool().safetyShield.maxSpeed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return ftShieldButton;
    }

    public Component createShieldComboBox() {
        this.shieldCB = new JComboBox<String>(stepperCommands);
        this.shieldCB.setFocusable(false);
        this.shieldCB.setPreferredSize(this.style.getCheckBoxSize());
        this.shieldCB.setMaximumSize(this.shieldCB.getPreferredSize());
        this.shieldCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GuideToolbarContribution.this._shieldCBState = (String)GuideToolbarContribution.this.shieldCB.getSelectedItem();
            }
        });
        return this.shieldCB;
    }

    public JLabel createConnectedIcon() {
        this.lblConnIcon = new JLabel();
        this.setToolConnection(false);
        return this.lblConnIcon;
    }

    public JLabel createConnectedBridgeIcon() {
        this.lblConnBridgeIcon = new JLabel();
        this.setBridgeConnection(false);
        return this.lblConnBridgeIcon;
    }

    public Component createErrorResetButton() {
        JButton ftErrorResetBtn = new JButton(this.getTextResource().toolbarResetErrors());
        ftErrorResetBtn.setBorder(this.style.getDefaultBtnBoarder());
        ftErrorResetBtn.setBackground(SwingAbstractStyle.URColor.UR_WHITE);
        ftErrorResetBtn.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        ftErrorResetBtn.setMaximumSize(ftErrorResetBtn.getPreferredSize());
        ftErrorResetBtn.setIgnoreRepaint(true);
        ftErrorResetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    new XMLRPCClient().setResetErrors();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        ftErrorResetBtn.addMouseListener(new MouseCustomAdapter(){

            @Override
            public void shortActionPerformed(MouseEvent e) {
            }

            @Override
            public void longActionPerformed(MouseEvent e) {
                GuideToolbarContribution.this.showDebug(!GuideToolbarContribution.this.ipComponent.isVisible());
            }
        });
        return ftErrorResetBtn;
    }

    public Component createBtnDoHoming() {
        this.btnDoHoming = new JButton(this.getTextResource().toolbarDoHomingBtn());
        this.btnDoHoming.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        this.btnDoHoming.setMaximumSize(this.btnDoHoming.getPreferredSize());
        this.btnDoHoming.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XMLRPCClient xmlrpcClient = new XMLRPCClient();
                    xmlrpcClient.setSafetyShieldCommand(5, 0.0, xmlrpcClient.getTool().safetyShield.maxSpeed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return this.btnDoHoming;
    }

    public Component createBtnMoveBitRelease() {
        this.btnMoveBitRelease = new JButton(this.getTextResource().toolbarReleaseBitBtn());
        this.btnMoveBitRelease.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        this.btnMoveBitRelease.setMaximumSize(this.btnMoveBitRelease.getPreferredSize());
        this.btnMoveBitRelease.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XMLRPCClient xmlrpcClient = new XMLRPCClient();
                    xmlrpcClient.setSafetyShieldCommand(11, 0.0, xmlrpcClient.getTool().safetyShield.maxSpeed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return this.btnMoveBitRelease;
    }

    public Component createBtnMoveBitLock() {
        this.btnMoveBitLock = new JButton(this.getTextResource().toolbarMoveLockBitBtn());
        this.btnMoveBitLock.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        this.btnMoveBitLock.setMaximumSize(this.btnMoveBitLock.getPreferredSize());
        this.btnMoveBitLock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    XMLRPCClient xmlrpcClient = new XMLRPCClient();
                    xmlrpcClient.setSafetyShieldCommand(10, 0.0, xmlrpcClient.getTool().safetyShield.maxSpeed);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        });
        return this.btnMoveBitLock;
    }

    private void showDebug(boolean show) {
        this.ipComponent.setVisible(show);
        this.cbShield.setVisible(show);
        this.btnShield.setVisible(show);
    }

    public KeyboardTextInput getKeyboardForIp() {
        this.updateSettingsIp();
        KeyboardTextInput keyboardInput = this.keyboardFactoryIp;
        keyboardInput.setInitialValue(this.settingsIp == null ? this.defaultIp.getText() : this.settingsIp);
        return keyboardInput;
    }

    public KeyboardInputCallback<String> getCallbackForIp() {
        return new KeyboardInputCallback<String>(){

            public void onOk(String value) {
                try {
                    new XMLRPCClient().connect(value, 1502);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                GuideToolbarContribution.this.defaultIp.setText(value);
            }
        };
    }

    private Box createLabelInputTextField(JTextField inputField, MouseAdapter mouseAdapter) {
        Box horizontalBox = Box.createHorizontalBox();
        horizontalBox.setAlignmentX(0.0f);
        inputField.setFocusable(false);
        inputField.setPreferredSize(new Dimension(200, 30));
        inputField.setMaximumSize(inputField.getPreferredSize());
        inputField.addMouseListener(mouseAdapter);
        horizontalBox.add(Box.createHorizontalGlue());
        horizontalBox.add(inputField);
        horizontalBox.add(Box.createRigidArea(new Dimension(5, 0)));
        return horizontalBox;
    }

    private void createGraph(int rowIndex) {
        XYSeries series = new XYSeries((Comparable)((Object)"Name"));
        SpinGraphRow row = this.spinGraphArray[rowIndex];
        for (int i = 0; i < row.torqueLog.length; ++i) {
            series.add((double)i / (double)row.sampleRate.intValue(), row.torqueLog[i]);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        this.chart = ChartFactory.createXYLineChart((String)this.getTextResource().toolbarGraphTitle(), (String)this.getTextResource().toolbarTimeSeconds(), (String)this.getTextResource().toolbarTorque(), (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plot = this.chart.getXYPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.BLACK);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.BLACK);
        this.chart.setTitle(new TextTitle(this.getTextResource().toolbarGraphTitle(), new Font("Serif", 1, 18)));
        this.chartPanel.setChart(this.chart);
    }

    private void createTable() {
        String[] columnNames = new String[]{this.getTextResource().toolbarTime(), this.getTextResource().toolbarTargetTorque(), this.getTextResource().toolbarFinalTorque(), this.getTextResource().toolbarSuccess()};
        this.logTable = new JTable(new SpinTableModel(columnNames));
        this.logTable.setPreferredSize(new Dimension(475, 250));
        this.logTable.setMaximumSize(this.logTable.getPreferredSize());
        DefaultTableCellRenderer iconRenderer = new DefaultTableCellRenderer();
        this.logTable.setDefaultRenderer(Icon.class, iconRenderer);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.logTable.setDefaultRenderer(String.class, centerRenderer);
        this.logTable.setDefaultRenderer(Double.class, centerRenderer);
        this.logTableHeader = this.logTable.getTableHeader();
        this.logTableHeader.setReorderingAllowed(false);
        this.logTableHeader.setPreferredSize(new Dimension(475, 25));
        this.logTableHeader.setMaximumSize(this.logTableHeader.getPreferredSize());
        this.logTable.setRowHeight(25);
        this.logTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (GuideToolbarContribution.this.logTable.getSelectedRow() > GuideToolbarContribution.this.rowCount || GuideToolbarContribution.this.logTable.getSelectedRow() < 0) {
                    return;
                }
                GuideToolbarContribution.this.createGraph(GuideToolbarContribution.this.logTable.getSelectedRow());
                GuideToolbarContribution.this.logTableHeader.setVisible(false);
                GuideToolbarContribution.this.logTable.setVisible(false);
                GuideToolbarContribution.this.chartPanel.setVisible(true);
                GuideToolbarContribution.this.btnReturn.setVisible(true);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void addRow() {
        try {
            ScrewProgramLog screwProgramLog = new XMLRPCClient().getScrewProgramLog();
            if (screwProgramLog == null || screwProgramLog.id == -1) {
                return;
            }
            SpinGraphRow spinGraphRow = new SpinGraphRow();
            spinGraphRow.timestamp = new SimpleDateFormat("HH:mm:ss").format(new Date(screwProgramLog.timestamp * 1000L));
            switch (screwProgramLog.typeId) {
                case 1: {
                    spinGraphRow.targetX = "-";
                    spinGraphRow.finalX = "-";
                    break;
                }
                case 2: {
                    spinGraphRow.targetX = String.format("%.2f", screwProgramLog.targetPosition * 1000.0) + " [mm]";
                    spinGraphRow.finalX = String.format("%.2f", screwProgramLog.finalPosition * 1000.0) + " [mm]";
                    break;
                }
                case 3: {
                    spinGraphRow.targetX = String.format("%.2f", screwProgramLog.targetTorque) + " [Nm]";
                    spinGraphRow.finalX = String.format("%.2f", screwProgramLog.finalTorque) + " [Nm]";
                    break;
                }
                default: {
                    return;
                }
            }
            spinGraphRow.success = new ImageIcon(Objects.requireNonNull(this.getClass().getResource(screwProgramLog.success ? "/com/spin/urcap/icons/UR_e-Series_1.0/G5_led_green.png" : "/com/spin/urcap/icons/UR_e-Series_1.0/G5_led_red.png")));
            spinGraphRow.torqueLog = screwProgramLog.torqueLog;
            spinGraphRow.sampleRate = screwProgramLog.sampleRate;
            spinGraphRow.id = screwProgramLog.id;
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(spinGraphRow.timestamp);
            row.add(spinGraphRow.targetX);
            row.add(spinGraphRow.finalX);
            row.add(spinGraphRow.success);
            ++this.rowCount;
            if (this.rowCount == 0) {
                for (int i = 0; i < 4; ++i) {
                    this.logTable.setValueAt(row.get(i), this.rowCount, i);
                }
                this.spinGraphArray[this.rowCount] = spinGraphRow;
            } else if (this.rowCount < 10) {
                int i;
                for (i = this.rowCount; i > 0; --i) {
                    for (int j = 0; j < 4; ++j) {
                        this.logTable.setValueAt(this.logTable.getValueAt(i - 1, j), i, j);
                    }
                    this.spinGraphArray[i] = this.spinGraphArray[i - 1];
                }
                for (i = 0; i < 4; ++i) {
                    this.logTable.setValueAt(row.get(i), 0, i);
                }
                this.spinGraphArray[0] = spinGraphRow;
            } else {
                int i;
                for (i = 9; i > 0; --i) {
                    for (int j = 0; j < 4; ++j) {
                        this.logTable.setValueAt(this.logTable.getValueAt(i - 1, j), i, j);
                    }
                    this.spinGraphArray[i] = this.spinGraphArray[i - 1];
                }
                for (i = 0; i < 4; ++i) {
                    this.logTable.setValueAt(row.get(i), 0, i);
                }
                this.spinGraphArray[0] = spinGraphRow;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createReturnBtn() {
        this.btnReturn = new JButton(this.getTextResource().toolbarReturn());
        this.btnReturn.setPreferredSize(new Dimension(BUTTON_DIMENSION));
        this.btnReturn.setMaximumSize(this.btnReturn.getPreferredSize());
        this.btnReturn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuideToolbarContribution.this.btnReturn.setVisible(false);
                GuideToolbarContribution.this.chartPanel.setVisible(false);
                GuideToolbarContribution.this.logTableHeader.setVisible(true);
                GuideToolbarContribution.this.logTable.setVisible(true);
            }
        });
    }

    private void setBtnsEnabled(boolean state) {
        this.btnMoveBitLock.setEnabled(state);
        this.btnMoveBitRelease.setEnabled(state);
        this.ftFreeRunningBtn.setEnabled(state);
    }

    private void updateSettingsIp() {
        this.settingsIp = ((InstallationContribution)this.apiProvider.getApplicationAPI().getInstallationNode(InstallationContribution.class)).getSettingsTabContribution().getBridgeIP();
    }

    private boolean isBridgeConnected() {
        return ((InstallationContribution)this.apiProvider.getApplicationAPI().getInstallationNode(InstallationContribution.class)).getTool2().isBridgeConnected();
    }

    private boolean isToolConnected() {
        return ((InstallationContribution)this.apiProvider.getApplicationAPI().getInstallationNode(InstallationContribution.class)).getTool2().isToolConnected();
    }

    @Override
    public void stop() {
        this.stopTimer();
    }

    static abstract class MouseCustomAdapter
    extends MouseAdapter {
        private long mousePressedTime;
        private final long delay = 3000L;
        private Timer flashTimer;
        private Color originalForegroungColor;

        @Override
        public void mousePressed(final MouseEvent e) {
            this.mousePressedTime = e.getWhen();
            if (this.flashTimer != null) {
                this.flashTimer.cancel();
            }
            this.flashTimer = new Timer("flash timer");
            this.flashTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    MouseCustomAdapter.this.originalForegroungColor = e.getComponent().getForeground();
                    e.getComponent().setForeground(Color.LIGHT_GRAY);
                }
            }, 3000L);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.flashTimer.cancel();
            e.getComponent().setForeground(this.originalForegroungColor);
            if (e.getWhen() - this.mousePressedTime > 3000L) {
                this.longActionPerformed(e);
            } else {
                this.shortActionPerformed(e);
            }
        }

        public abstract void shortActionPerformed(MouseEvent var1);

        public abstract void longActionPerformed(MouseEvent var1);
    }

    private static class SpinGraphRow {
        Integer id;
        String timestamp;
        String targetX;
        String finalX;
        Icon success;
        double[] torqueLog;
        Integer sampleRate;

        SpinGraphRow() {
        }
    }

    private static class SpinTableModel
    extends AbstractTableModel {
        private final String[] columnNames;
        private final Object[][] data = new Object[10][4];

        SpinTableModel(String[] columnNames) {
            this.columnNames = columnNames;
            ImageIcon icon = new ImageIcon();
            for (int i = 0; i < 10; ++i) {
                this.data[i][0] = "";
                this.data[i][1] = "";
                this.data[i][2] = "";
                this.data[i][3] = icon;
            }
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                return;
            }
            this.data[rowIndex][columnIndex] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    }
}

