/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.xmlrpc;

import com.spin.urcap.impl.daemons.secondary_client.SecondaryClient;
import com.spin.urcap.impl.daemons.xmlrpc.XMLRPCClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;

public class RobotStateTask
implements Runnable {
    private final int[] dashboardAttempts = new int[]{0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Spin" + this.getClass().getSimpleName());
        try {
            String staticClassName = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
            Socket dashboardClient = null;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    System.out.println(staticClassName + ": Creating socket and trying to connect to dashboard server..");
                    this.dashboardAttempts[0] = this.dashboardAttempts[0] + 1;
                    dashboardClient = new Socket("127.0.0.1", 29999);
                    System.out.println(staticClassName + ": Connected to dashboard server!");
                    OutputStream dashboardOS = dashboardClient.getOutputStream();
                    InputStream dashboardIS = dashboardClient.getInputStream();
                    BufferedReader dashboardReader = new BufferedReader(new InputStreamReader(dashboardIS));
                    OutputStream dashboardOS2 = dashboardClient.getOutputStream();
                    InputStream dashboardIS2 = dashboardClient.getInputStream();
                    BufferedReader dashboardReader2 = new BufferedReader(new InputStreamReader(dashboardIS2));
                    boolean risingEdge = false;
                    boolean gpbiSet = false;
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            if (!gpbiSet) {
                                dashboardOS.write("robotmode\n".getBytes());
                                if (!dashboardReader.readLine().equals("Robotmode: RUNNING")) continue;
                                RobotStateTask robotStateTask = this;
                                synchronized (robotStateTask) {
                                    this.wait(500L);
                                }
                                SecondaryClient secondaryClient = new SecondaryClient();
                                secondaryClient.sendScriptCommand("set_gp_boolean_input_action(64, \"freedrive\")");
                                gpbiSet = true;
                                continue;
                            }
                            dashboardOS2.write("programState\n".getBytes());
                            String line = dashboardReader2.readLine();
                            boolean playing = line.substring(0, line.indexOf(" ")).equals("PLAYING");
                            if (!playing && risingEdge) {
                                risingEdge = false;
                                XMLRPCClient xmlrpcClient = new XMLRPCClient();
                                xmlrpcClient.setScrewProgramCommand(0, 0, 0.0);
                                xmlrpcClient.setScrewCommand(0, 0, 0);
                                xmlrpcClient.setSafetyShieldCommand(0, 0.0, 0.0);
                            } else {
                                risingEdge = playing;
                            }
                            RobotStateTask robotStateTask = this;
                            synchronized (robotStateTask) {
                                this.wait(150L);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    RobotStateTask robotStateTask = this;
                    synchronized (robotStateTask) {
                        try {
                            this.wait(1000L);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (this.dashboardAttempts[0] == 30) {
                        System.out.println(staticClassName + ": Could not connect to dashboard server. Attempted 30 times, stopping");
                        break;
                    }
                    System.out.println(staticClassName + ": Could not connect to dashboard server. Retrying...");
                }
            }
            dashboardClient.close();
            System.out.println(staticClassName + ": robotStateThread stopped");
            RobotStateTask robotStateTask = this;
            synchronized (robotStateTask) {
                this.notifyAll();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

