/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes.load_screw;

import com.spin.urcap.impl.installation_node.InstallationContribution;
import com.spin.urcap.impl.installation_node.feeder.Feeder;
import com.spin.urcap.impl.installation_node.feeder.FeederContribution;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.program_nodes.load_screw.LoadScrewData;
import com.spin.urcap.impl.program_nodes.load_screw.LoadScrewView;
import com.spin.urcap.impl.util.Compare;
import com.spin.urcap.impl.util.SpinUnits;
import com.spin.urcap.impl.util.soft_safety.SoftSafety;
import com.spin.urcap.impl.util.soft_safety.SoftSafetyData;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.UUID;
import java.util.Vector;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class LoadScrewContribution
implements ProgramNodeContribution {
    private static SpinUnits spinUnits;
    private static FeederContribution feederContribution;
    private final ProgramAPIProvider apiProvider;
    private final ProgramAPI programAPI;
    private final SimpleValueFactory valueFactory;
    private final LanguagePack languagePack;
    private final LoadScrewView view;
    private final LoadScrewData data;
    private final SoftSafetyData softSafetyData;

    public LoadScrewContribution(ProgramAPIProvider apiProvider, LoadScrewView view, DataModel model) {
        this.languagePack = new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization());
        this.apiProvider = apiProvider;
        this.programAPI = apiProvider.getProgramAPI();
        this.valueFactory = apiProvider.getProgramAPI().getValueFactoryProvider().getSimpleValueFactory();
        this.view = view;
        this.data = new LoadScrewData(model);
        feederContribution = ((InstallationContribution)apiProvider.getProgramAPI().getInstallationNode(InstallationContribution.class)).getFeederTabContribution();
        spinUnits = ((InstallationContribution)apiProvider.getProgramAPI().getInstallationNode(InstallationContribution.class)).getSpinUnits();
        this.softSafetyData = new SoftSafetyData(model);
        SoftSafety.init(this.valueFactory);
    }

    public void openView() {
        this.initCombo();
        this.initSafetyPanel();
        this.setMessages();
        this.updateMessages();
    }

    public void closeView() {
    }

    public String getTitle() {
        String nodeTitle = this.languagePack.getCommandNamesResource().nodeNameLoadScrew();
        Feeder selectedFeeder = this.loadSelectedFeeder();
        String nodeSuffix = selectedFeeder != null ? ": " + selectedFeeder : "";
        return nodeTitle + nodeSuffix;
    }

    public boolean isDefined() {
        Feeder selectedFeeder = this.loadSelectedFeeder();
        return selectedFeeder != null && selectedFeeder.isFeederValid();
    }

    public void generateScript(ScriptWriter writer) {
        Feeder feeder = this.loadSelectedFeeder();
        SoftSafety softSafety = this.softSafetyData.loadSoftSafety();
        assert (feeder != null);
        writer.appendLine("spin_pick_up_screw(" + feeder.getPose() + ",\"" + feeder.getName() + "\"," + feeder.getRetriesCount() + "," + feeder.getSpeed().getAs(Speed.Unit.M_S) + "," + feeder.getScrewLength().getAs(Length.Unit.M) + "," + feeder.getOffset().getAs(Length.Unit.M) + "," + softSafety.getSafetyForce().getAs(Force.Unit.N) + "," + (softSafety.isSafetyEnabled() ? "True" : "False") + ")");
    }

    private void initCombo() {
        Feeder selectedFeeder = this.loadSelectedFeeder();
        Vector<Feeder> feeders = feederContribution.loadFeeders();
        this.view.getCombo().removeAllItems();
        if (feeders.size() <= 0) {
            this.view.getCombo().setDefaultText(LanguagePack.getTextResource().feederComboNoFeeder());
            this.saveSelectedFeeder(null);
            return;
        }
        this.view.getCombo().setItems(feeders);
        if (selectedFeeder == null) {
            this.view.getCombo().setDefaultText(LanguagePack.getTextResource().feederComboSelectFeeder());
        }
        this.view.getCombo().setEditable(true);
        this.view.getCombo().setSelectedItem(selectedFeeder);
        this.view.getCombo().setEditable(false);
    }

    public void selectFeeder() {
        final Feeder feeder = (Feeder)this.view.getCombo().getSelectedItem();
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                LoadScrewContribution.this.saveSelectedFeeder(feeder);
            }
        });
        this.updateMessages();
    }

    @Nullable
    private Feeder getSelectedFeeder() {
        return (Feeder)this.view.getCombo().getSelectedItem();
    }

    public void initSafetyPanel() {
        SoftSafety softSafety = this.softSafetyData.loadSoftSafety();
        this.view.getSafetyPanel().setWarningStyle(softSafety.isSafetyEnabled());
        this.view.getSafetyPanel().getLblEnable().setText(LanguagePack.getTextResource().softSafetyEnable());
        this.view.getSafetyPanel().getLblForce().setText(LanguagePack.getTextResource().softSafetyMaxForce());
        this.view.getSafetyPanel().getLblForceUnit().setText(spinUnits.getForceUnitText());
        this.view.getSafetyPanel().getCheckBoxEnable().setSelected(softSafety.isSafetyEnabled());
        this.view.getSafetyPanel().getTfForce().setText(String.valueOf(softSafety.getSafetyForce().getAs(spinUnits.getForceUnit())));
        this.view.getSafetyPanel().getLblWarning().setText(LanguagePack.getTextResource().softSafetyWarning());
    }

    public void setSafetyEnabled() {
        final SoftSafety softSafety = this.softSafetyData.loadSoftSafety();
        final boolean enabled = this.view.getSafetyPanel().getCheckBoxEnable().isSelected();
        softSafety.setSafetyEnabled(enabled);
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                LoadScrewContribution.this.view.getSafetyPanel().setWarningStyle(enabled);
                LoadScrewContribution.this.softSafetyData.saveSoftSafety(softSafety);
            }
        });
    }

    public void setSafetyForce() {
        final SoftSafety softSafety = this.softSafetyData.loadSoftSafety();
        if (!softSafety.isSafetyEnabled()) {
            return;
        }
        KeyboardNumberInput input = this.apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory().createDoubleKeypadInput();
        input.setInitialValue((Object)softSafety.getSafetyForce().getAs(spinUnits.getForceUnit()));
        input.setErrorValidator((InputValidator)new InputValidator<Double>(){

            public boolean isValid(Double value) {
                Force inputForce = LoadScrewContribution.this.valueFactory.createForce(value.doubleValue(), spinUnits.getForceUnit());
                return SoftSafety.safetyForceIsValid(inputForce);
            }

            public String getMessage(Double value) {
                return String.format(LanguagePack.getTextResource().msgFloatOutOfRange(), SoftSafety.getMinSafetyForce().getAs(spinUnits.getForceUnit()), SoftSafety.getMaxSafetyForce().getAs(spinUnits.getForceUnit()));
            }
        });
        input.show((JTextField)this.view.getSafetyPanel().getTfForce(), (KeyboardInputCallback)new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                final Force force = LoadScrewContribution.this.valueFactory.createForce(value.doubleValue(), spinUnits.getForceUnit());
                softSafety.setSafetyForce(force);
                LoadScrewContribution.this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

                    public void executeChanges() {
                        LoadScrewContribution.this.softSafetyData.saveSoftSafety(softSafety);
                        LoadScrewContribution.this.view.getSafetyPanel().getTfForce().setText(String.valueOf(force.getAs(spinUnits.getForceUnit())));
                    }
                });
            }
        });
    }

    private void setMessages() {
        this.view.getMessagePanel().getMsgSelectFeeder().setMessage(LanguagePack.getTextResource().loadScrewMsgSelectFeeder());
        this.view.getMessagePanel().getMsgFeederInvalidFeeder().setMessage(LanguagePack.getTextResource().loadScrewMsgInvalidFeeder());
        this.view.getMessagePanel().getMsgOffsetLow().setMessage(String.format(LanguagePack.getTextResource().feederMsgOffsetLow(), LanguagePack.getTextResource().loadScrewOffset2(), Feeder.getWarnLowOffset().getAs(spinUnits.getLengthUnit()), spinUnits.getLengthUnitText()));
        this.view.getMessagePanel().getMsgNoFeedersDefined().setMessage(LanguagePack.getTextResource().loadScrewMsgNoFeeder());
        this.view.getMessagePanel().getMsgScrewLength().setMessage(LanguagePack.getTextResource().feederMsgScrewLength());
        this.view.getMessagePanel().getMsgSetScrewPosition().setMessage(LanguagePack.getTextResource().feederMsgSetScrewPosition());
    }

    private void updateMessages() {
        boolean feedersExist;
        boolean feederSelected = false;
        boolean feederIsValid = false;
        boolean offsetLow = false;
        boolean screwLengthIsLow = false;
        boolean screwPositionIsValid = false;
        boolean bl = feedersExist = this.view.getCombo().getItemCount() > 0;
        if (feedersExist) {
            Feeder feeder = this.getSelectedFeeder();
            boolean bl2 = feederSelected = feeder != null;
            if (feederSelected) {
                screwLengthIsLow = Compare.epsilonLessThan(feeder.getScrewLength(), Feeder.getWarnLowScrewLength());
                screwPositionIsValid = feeder.getPose() != null;
                feederIsValid = feeder.isFeederValid();
                if (feederIsValid) {
                    offsetLow = Compare.epsilonLessThan(feeder.getOffset(), Feeder.getWarnLowOffset());
                }
            }
        }
        this.view.getMessagePanel().getMsgNoFeedersDefined().setVisible(!feedersExist);
        this.view.getMessagePanel().getMsgSelectFeeder().setVisible(feedersExist && !feederSelected);
        this.view.getMessagePanel().getMsgFeederInvalidFeeder().setVisible(feedersExist && feederSelected && !feederIsValid);
        this.view.getMessagePanel().getMsgOffsetLow().setVisible(feedersExist && feederSelected && feederIsValid && offsetLow);
        this.view.getMessagePanel().getMsgScrewLength().setVisible(feedersExist && feederSelected && screwLengthIsLow);
        this.view.getMessagePanel().getMsgSetScrewPosition().setVisible(feedersExist && feederSelected && !screwPositionIsValid);
    }

    @Nullable
    private Feeder loadSelectedFeeder() {
        UUID selectedFeederId = this.data.loadSelectedFeederId();
        if (selectedFeederId == null) {
            return null;
        }
        return feederContribution.loadFeeder(selectedFeederId);
    }

    private void saveSelectedFeeder(@Nullable Feeder feeder) {
        this.data.saveSelectedFeederId(feeder == null ? null : feeder.getId());
    }
}

