/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.move_to_screw;

import com.spin.core.program_node.move_to_screw.MoveToScrewData;
import com.spin.core.program_node.move_to_screw.MoveToScrewScriptGenerator;
import com.spin.core.program_node.move_to_screw.MoveToScrewText;
import com.spin.core.program_node.move_to_screw.MoveToScrewView;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveToScrewContribution
implements ProgramNodeContribution {
    @NotNull
    private final MoveToScrewView view;
    @NotNull
    private final MoveToScrewData data;
    @NotNull
    private final MoveToScrewScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final UserInteraction userInteraction;
    @NotNull
    private final PoseFactory poseFactory;

    MoveToScrewContribution(@NotNull MoveToScrewView moveToScrewView, @NotNull MoveToScrewData data, @NotNull MoveToScrewScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.view = moveToScrewView;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
        this.userInteraction = apiProvider.getProgramAPIProvider().getUserInterfaceAPI().getUserInteraction();
        this.poseFactory = apiProvider.getProgramAPIProvider().getProgramAPI().getValueFactoryProvider().getPoseFactory();
    }

    public void openView() {
        this.view.setApproachEnabled(this.data.approachEnabled());
        if (this.data.getPose() == null) {
            this.view.setButtonStyleAsTeach();
            this.view.verifyPositionButtonEnabled(false);
        } else {
            this.view.setButtonStyleAsReTeach();
            this.view.verifyPositionButtonEnabled(true);
        }
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(MoveToScrewText.MOVE_TO_SCREW_TITLE);
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    public void generateScript(ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
    }

    void onExitVerifyPosition() {
        this.view.toggleActivePanel();
    }

    void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    void setPose(@NotNull Pose pose) {
        this.data.setPose(pose);
    }

    @NotNull
    Pose poseAbove() {
        Pose pose = Objects.requireNonNull(this.data.getPose());
        Position pos = pose.getPosition();
        Rotation rot = pose.getRotation();
        return this.poseFactory.createPose(pos.getX(Length.Unit.MM), pos.getY(Length.Unit.MM), pos.getZ(Length.Unit.MM) + 50.0, rot.getRX(Angle.Unit.DEG), rot.getRY(Angle.Unit.DEG), rot.getRZ(Angle.Unit.DEG), Length.Unit.MM, Angle.Unit.DEG);
    }

    @Nullable
    Pose pose() {
        return this.data.getPose();
    }

    @NotNull
    UserInteraction getUserInteraction() {
        return this.userInteraction;
    }
}

