/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw;

import com.spin.core.installation_node.InstallationContribution;
import com.spin.core.program_node.load_screw.LoadScrewData;
import com.spin.core.program_node.load_screw.LoadScrewScriptGenerator;
import com.spin.core.program_node.load_screw.LoadScrewText;
import com.spin.core.program_node.load_screw.LoadScrewView;
import com.spin.domain.ScrewFeeder;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.domain.script.ScriptWriter;
import org.jetbrains.annotations.NotNull;

public class LoadScrewContribution
implements ProgramNodeContribution {
    @NotNull
    private final LoadScrewView loadScrewView;
    @NotNull
    private final LoadScrewData data;
    @NotNull
    private final LoadScrewScriptGenerator scriptGenerator;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final InstallationContribution installationContribution;

    LoadScrewContribution(@NotNull LoadScrewView loadScrewView, @NotNull LoadScrewData data, @NotNull LoadScrewScriptGenerator scriptGenerator, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.loadScrewView = loadScrewView;
        this.data = data;
        this.scriptGenerator = scriptGenerator;
        this.textResource = apiProvider.getTextResource();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
    }

    public void openView() {
        this.loadScrewView.setScrewFeeders(this.installationContribution.getScrewFeeders());
        this.loadScrewView.selectedScrewFeeder(this.data.selectedScrewFeeder());
        this.loadScrewView.setApproachEnabled(this.data.approachEnabled());
        this.loadScrewView.setDepartEnabled(this.data.departEnabled());
    }

    public void closeView() {
    }

    public String getTitle() {
        return this.textResource.load(LoadScrewText.LOAD_SCREW);
    }

    public boolean isDefined() {
        return this.data.isValidConfiguration();
    }

    void selectScrewFeeder(@NotNull ScrewFeeder screwFeeder) {
        this.data.setSelectedScrewFeeder(screwFeeder);
    }

    public void generateScript(@NotNull ScriptWriter writer) {
        this.scriptGenerator.generateScript(writer, this.textResource, this.data);
    }

    public void setApproachEnabled(boolean enabled) {
        this.data.setApproachEnabled(enabled);
    }

    public void setDepartEnabled(boolean enabled) {
        this.data.setDepartEnabled(enabled);
    }
}

