/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util;

import com.spin.util.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleAction {
    @NotNull
    private final Action toggledTrueAction;
    @NotNull
    private final Action toggledFalseAction;
    @NotNull
    private final Action toggledNullAction;
    @NotNull
    private State lastState;

    private ToggleAction(@NotNull Action toggledTrueAction, @NotNull Action toggledFalseAction, @NotNull Action toggledNullAction, @Nullable Boolean initialState) {
        this.toggledTrueAction = toggledTrueAction;
        this.toggledFalseAction = toggledFalseAction;
        this.toggledNullAction = toggledNullAction;
        this.lastState = State.asState(initialState);
    }

    public void setStateAndReact(@Nullable Boolean newState) {
        try {
            State state = State.asState(newState);
            this.invokeActionIfStateChanged(state);
        }
        catch (Action.AbortAction abortAction) {
            // empty catch block
        }
    }

    private void invokeActionIfStateChanged(@NotNull State state) throws Action.AbortAction {
        if (state == this.lastState) {
            return;
        }
        if (state == State.TRUE) {
            this.toggledTrueAction.run();
        } else if (state == State.FALSE) {
            this.toggledFalseAction.run();
        } else {
            this.toggledNullAction.run();
        }
        this.lastState = state;
    }

    public static class Builder {
        private static final Action doNothingAction = () -> {};
        private static final Action nullNotAllowedAction = () -> {
            throw new IllegalArgumentException("Null is not allowed when tri-state is not allowed");
        };
        private Action toggledTrueAction = doNothingAction;
        private Action toggledFalseAction = doNothingAction;
        private Action toggledNullAction = nullNotAllowedAction;
        private boolean allowTriState = false;

        @NotNull
        public Builder doWhenToggledToTrue(@NotNull Action action) {
            this.toggledTrueAction = action;
            return this;
        }

        @NotNull
        public Builder doWhenToggledToFalse(@NotNull Action action) {
            this.toggledFalseAction = action;
            return this;
        }

        @NotNull
        public Builder doWhenToggledToNull(@NotNull Action action) {
            this.toggledNullAction = action;
            return this;
        }

        @NotNull
        public Builder allowTriState() {
            this.allowTriState = true;
            if (this.toggledNullAction == nullNotAllowedAction) {
                this.toggledNullAction = doNothingAction;
            }
            return this;
        }

        @NotNull
        public ToggleAction buildWithInitialState(@Nullable Boolean initialState) {
            if (!this.allowTriState) {
                this.verifyValidConfiguration(initialState);
            }
            return new ToggleAction(this.toggledTrueAction, this.toggledFalseAction, this.toggledNullAction, initialState);
        }

        private void verifyValidConfiguration(@Nullable Boolean initialState) {
            if (this.toggledNullAction != nullNotAllowedAction) {
                throw new IllegalStateException("Toggle to null action must not be configured when tri-state is not allowed");
            }
            if (initialState == null) {
                throw new IllegalArgumentException("Initial state may not be null if tri-state is not allowed");
            }
        }
    }

    private static enum State {
        TRUE,
        FALSE,
        NULL;


        @NotNull
        static State asState(@Nullable Boolean state) {
            if (state == null) {
                return NULL;
            }
            return state != false ? TRUE : FALSE;
        }
    }
}

