/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bridge_tool;

import com.spin.core.installation_node.bridge_tool.BridgeAndToolContribution;
import com.spin.core.installation_node.bridge_tool.BridgeAndToolText;
import com.spin.domain.BridgeInfo;
import com.spin.domain.DiscoveredBridge;
import com.spin.domain.SpinSoftwareVersion;
import com.spin.domain.ToolInfo;
import com.spin.ui.callback.OnOkCallback;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.LongPressListener;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.ui.urstyle.UR_Color;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.spin.util.logging.SpinLog;
import com.spin.util.stream.OptionalUtil;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardTextInput;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BridgeAndToolView
implements SwingInstallationNodeView<BridgeAndToolContribution> {
    @NotNull
    private final ImageIcon connectionOKIcon;
    @NotNull
    private final ImageIcon connectionNotOKIcon;
    @NotNull
    private final ImageIcon connectionUnknownIcon;
    @NotNull
    private final ImagePanel bridgeConnectionImage;
    @NotNull
    private final ImagePanel toolConnectionImage;
    @NotNull
    private final JPanel robotDetails;
    @NotNull
    private final JPanel bridgeDetails;
    @NotNull
    private final JPanel toolDetails;
    @NotNull
    private final JPanel versionCompatibility;
    @NotNull
    private final JPanel toolNeedsFirmwareUpdatePanel;
    @NotNull
    private final Label bridgeSerialNumber;
    @NotNull
    private final Label bridgeSoftwareVersion;
    @NotNull
    private final Label toolSerialNumber;
    @NotNull
    private final Label toolSoftwareVersion;
    @NotNull
    private final Label toolNeedsFirmwareUpdate;
    @NotNull
    private final MessageBoxSmall badBridgeSoftwareVersion;
    @NotNull
    private final MessageBoxSmall badURCapVersion;
    @NotNull
    private final MessageBoxSmall doubleBadVersion;
    @NotNull
    private final TextResource textResource;
    @NotNull
    private final ComboBox<DiscoveredBridge> bridgeSelector;
    @NotNull
    private final ImagePanel logo;
    @Nullable
    private BridgeInfo connectedBridgeInfo = null;
    @Nullable
    private ToolInfo connectedToolInfo = null;

    public BridgeAndToolView(@NotNull ExtendedViewAPIProvider apiProvider) {
        this.textResource = apiProvider.getTextResource();
        this.connectionOKIcon = SpinIcon.CONNECTION_OK.load();
        this.connectionNotOKIcon = SpinIcon.CONNECTION_NOT_OK.load();
        this.connectionUnknownIcon = SpinIcon.CONNECTION_UNKNOWN.load();
        this.bridgeConnectionImage = new ImagePanel(this.connectionNotOKIcon);
        this.toolConnectionImage = new ImagePanel(this.connectionNotOKIcon);
        this.bridgeSerialNumber = new Label();
        this.bridgeSoftwareVersion = new Label();
        this.toolSerialNumber = new Label();
        this.toolSoftwareVersion = new Label();
        this.toolNeedsFirmwareUpdate = new Label(this.textResource.load(BridgeAndToolText.NEEDS_FIRMWARE_UPDATE));
        this.bridgeSelector = new ComboBox();
        this.bridgeSelector.setEditable(true);
        this.robotDetails = new JPanel((LayoutManager)new MigLayout("insets 10, gap 20", "[][grow]", ""));
        this.bridgeDetails = new JPanel((LayoutManager)new MigLayout("insets 10, gap 20", "[][grow]", ""));
        this.toolDetails = new JPanel((LayoutManager)new MigLayout("insets 10, gap 20", "[][][grow]", ""));
        this.robotDetails.setBorder(BorderFactory.createLineBorder(UR_Color.GRAY4, 5));
        this.bridgeDetails.setBorder(BorderFactory.createLineBorder(UR_Color.GRAY4, 5));
        this.toolDetails.setBorder(BorderFactory.createLineBorder(UR_Color.GRAY4, 5));
        this.badBridgeSoftwareVersion = new MessageBoxSmall(this.textResource.load(BridgeAndToolText.BAD_BRIDGE_SW_VERSION), AbstractMessageBox.Type.WARNING);
        this.badURCapVersion = new MessageBoxSmall(this.textResource.load(BridgeAndToolText.BAD_URCAP_VERSION), AbstractMessageBox.Type.WARNING);
        this.doubleBadVersion = new MessageBoxSmall("You got your version numbers all messed up dude!", AbstractMessageBox.Type.WARNING);
        this.badBridgeSoftwareVersion.setVisible(false);
        this.badURCapVersion.setVisible(false);
        this.doubleBadVersion.setVisible(false);
        this.versionCompatibility = new JPanel((LayoutManager)new MigLayout("insets 10, gap 20", "[]", "[][]"));
        this.versionCompatibility.add((Component)new Label(UR_Icon.WARNING_SMALL.load()), "cell 0 0");
        this.versionCompatibility.add((Component)this.badBridgeSoftwareVersion, "cell 1 0, hidemode 3");
        this.versionCompatibility.add((Component)this.badURCapVersion, "cell 1 0, hidemode 3");
        this.versionCompatibility.add((Component)this.doubleBadVersion, "cell 1 0, hidemode 3");
        this.versionCompatibility.setVisible(false);
        this.toolNeedsFirmwareUpdatePanel = new JPanel((LayoutManager)new MigLayout("insets 0, gap 0", "[]", "[][]"));
        this.toolNeedsFirmwareUpdatePanel.add((Component)new Label(UR_Icon.WARNING_SMALL.load()), "cell 0 0");
        this.toolNeedsFirmwareUpdatePanel.add((Component)this.toolNeedsFirmwareUpdate, "cell 1 0");
        String urcapVersion = this.textResource.load(BridgeAndToolText.URCAP_VERSION);
        String serialNumber = this.textResource.load(BridgeAndToolText.SERIAL_NUMBER);
        String softwareVersion = this.textResource.load(BridgeAndToolText.SOFTWARE_VERSION);
        String polyscopeVersion = this.textResource.load(BridgeAndToolText.POLYSCOPE_VERSION);
        this.robotDetails.add((Component)new Label(urcapVersion), "cell 0 0");
        this.robotDetails.add((Component)new Label(SpinSoftwareVersion.getThisURCapVersion().toString()), "cell 1 0");
        this.robotDetails.add((Component)new Label(polyscopeVersion), "cell 0 1");
        this.robotDetails.add((Component)new Label(SpinSoftwareVersion.parse(apiProvider.getViewAPIProvider().getSystemAPI().getSoftwareVersion()).toString()), "cell 1 1");
        this.bridgeDetails.add((Component)new Label(serialNumber), "cell 0 0");
        this.bridgeDetails.add((Component)this.bridgeSerialNumber, "cell 1 0");
        this.bridgeDetails.add((Component)new Label(softwareVersion), "cell 0 1");
        this.bridgeDetails.add((Component)this.bridgeSoftwareVersion, "cell 1 1");
        this.toolDetails.add((Component)new Label(serialNumber), "cell 0 0");
        this.toolDetails.add((Component)this.toolSerialNumber, "cell 1 0");
        this.toolDetails.add((Component)new Label(softwareVersion), "cell 0 1");
        this.toolDetails.add((Component)this.toolSoftwareVersion, "cell 1 1");
        this.toolDetails.add((Component)this.toolNeedsFirmwareUpdatePanel, "cell 0 2, span 2 1, hidemode 3");
        this.toolNeedsFirmwareUpdatePanel.setVisible(false);
        this.logo = new ImagePanel(SpinIcon.LOGO_INSTALLATION_NODE.load());
    }

    public void buildUI(@NotNull JPanel panel, @NotNull BridgeAndToolContribution contribution) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 20, "[]push[center]5[]40[top][]push"));
        panel.add((Component)this.logo, "cell 9 0, span 3, right");
        panel.add((Component)new ImagePanel(SpinImage.ROBOT.load()), "cell 0 1, span 2, align 70%");
        panel.add((Component)new ImagePanel(SpinImage.BRIDGE.load()), "cell 3 1, span 5, align 60%");
        panel.add((Component)new ImagePanel(SpinImage.TOOL.load()), "cell 8 1, span 4, align 56%");
        panel.add((Component)this.bridgeConnectionImage, "cell 2 1, span 3");
        panel.add((Component)this.toolConnectionImage, "cell 7 1, span 3");
        String ipAddress = this.textResource.load(BridgeAndToolText.IP_ADDRESS);
        panel.add((Component)new Label(ipAddress), "cell 2 2, span 2, right");
        panel.add(this.bridgeSelector, "cell 4 2, span 4, grow");
        panel.add((Component)this.robotDetails, "cell 0 3, span 3, grow");
        panel.add((Component)this.bridgeDetails, "cell 3 3, span 5, grow");
        panel.add((Component)this.toolDetails, "cell 8 3, span 4, grow");
        panel.add((Component)this.versionCompatibility, "cell 0 4, span 12, grow");
        this.registerListeners(contribution);
    }

    private void registerListeners(final @NotNull BridgeAndToolContribution contribution) {
        this.bridgeSelector.addActionListener(event -> this.updateBridgeIP(contribution));
        this.bridgeSelector.getEditor().getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                BridgeAndToolView.this.showBridgeIPKeyboard(contribution);
            }
        });
        this.logo.addMouseListener(new LongPressListener(){

            @Override
            protected void onLongPress() {
                contribution.toggleExhibitionMode();
            }
        });
    }

    private void showBridgeIPKeyboard(@NotNull BridgeAndToolContribution contribution) {
        KeyboardTextInput keyboard = contribution.getBridgeIPKeyboard();
        keyboard.show((JTextField)this.bridgeSelector.getEditor().getEditorComponent(), new OnOkCallback<String>(addressString -> this.updateBridgeIP(contribution, (String)addressString)));
    }

    private void updateBridgeIP(@NotNull BridgeAndToolContribution contribution) {
        DiscoveredBridge bridge = (DiscoveredBridge)this.bridgeSelector.getSelectedItem();
        if (bridge != null && this.bridgeSelector.getItemCount() > 0) {
            contribution.onBridgeIPChanged(bridge.ip());
        }
    }

    private void updateBridgeIP(@NotNull BridgeAndToolContribution contribution, @NotNull String addressString) {
        InetAddress ipAddress = this.asInetAddress(addressString);
        contribution.onBridgeIPChanged(ipAddress);
    }

    @NotNull
    private InetAddress asInetAddress(@NotNull String addressString) {
        try {
            return Inet4Address.getByName(addressString);
        }
        catch (UnknownHostException e) {
            assert (false) : "Invalid address entered. This should not be possible.";
            throw new RuntimeException(e);
        }
    }

    void setBridgeIPAddress(@NotNull InetAddress address) {
        this.bridgeSelector.runWithoutFiringActionsEvents(() -> this.findAndSetBridgeIP(address));
    }

    private void findAndSetBridgeIP(@NotNull InetAddress address) {
        Optional<DiscoveredBridge> bridgeToSelect = this.bridgeSelector.getAllItems().stream().filter(discoveredBridge -> discoveredBridge.ip().equals(address)).findFirst();
        OptionalUtil.ifPresentOrElse(bridgeToSelect, this.bridgeSelector::setSelectedItem, () -> this.addAndSelectCustomBridge(address));
    }

    private void addAndSelectCustomBridge(@NotNull InetAddress address) {
        DiscoveredBridge customBridge = new DiscoveredBridge(address);
        this.bridgeSelector.addItem(customBridge);
        this.bridgeSelector.setSelectedItem(customBridge);
    }

    void setBridgeDisconnected() {
        this.connectedBridgeInfo = null;
        this.updateBridgeConnection();
        this.updateToolConnection();
    }

    void setBridgeConnected(@NotNull BridgeInfo bridgeInfo) {
        this.connectedBridgeInfo = bridgeInfo;
        this.updateBridgeConnection();
        this.updateToolConnection();
    }

    void setToolDisconnected() {
        this.connectedToolInfo = null;
        this.updateToolConnection();
    }

    void setToolConnected(@NotNull ToolInfo toolInfo) {
        this.connectedToolInfo = toolInfo;
        this.updateToolConnection();
    }

    private void updateBridgeConnection() {
        if (this.connectedBridgeInfo == null) {
            this.showBridgeDisconnected();
        } else {
            this.showBridgeConnected(this.connectedBridgeInfo);
        }
    }

    private void updateToolConnection() {
        if (this.connectedBridgeInfo == null) {
            this.showToolConnectionUnknown();
        } else if (this.connectedToolInfo == null) {
            this.showToolDisconnected();
        } else {
            this.showToolConnected(this.connectedToolInfo);
        }
    }

    private void showBridgeDisconnected() {
        this.bridgeConnectionImage.setIcon(this.connectionNotOKIcon);
        this.bridgeDetails.setVisible(false);
        this.versionCompatibility.setVisible(false);
    }

    private void showBridgeConnected(@NotNull BridgeInfo bridgeInfo) {
        this.checkCompatibility(bridgeInfo);
        this.bridgeSerialNumber.setText(bridgeInfo.serialNumber().toString());
        this.bridgeSoftwareVersion.setText(bridgeInfo.softwareVersion().toString());
        this.bridgeConnectionImage.setIcon(this.connectionOKIcon);
        this.bridgeDetails.setVisible(true);
    }

    private void checkCompatibility(@NotNull BridgeInfo bridgeInfo) {
        boolean badBridgeSoftwareVersion;
        boolean badURCapVersion = false;
        try {
            badBridgeSoftwareVersion = !bridgeInfo.softwareVersion().isNewerThan(SpinSoftwareVersion.getMinimumBridgeVersion());
        }
        catch (RuntimeException e) {
            SpinLog.print("Could not parse bridge software version: " + bridgeInfo.softwareVersion());
            this.versionCompatibility.setVisible(false);
            return;
        }
        if (bridgeInfo.minURCapsVersion() != null) {
            try {
                badURCapVersion = !SpinSoftwareVersion.getThisURCapVersion().isNewerThan(bridgeInfo.minURCapsVersion());
            }
            catch (RuntimeException e) {
                SpinLog.print("Could not parse bridge software version: " + bridgeInfo.softwareVersion());
                this.versionCompatibility.setVisible(false);
                return;
            }
        }
        if (badBridgeSoftwareVersion && badURCapVersion) {
            this.showDoubleBadVersion(true);
        } else if (badBridgeSoftwareVersion) {
            this.showBadBridgeSoftwareVersion(true);
        } else if (badURCapVersion) {
            this.showBadURCapVersion(true);
        } else {
            this.versionCompatibility.setVisible(false);
        }
    }

    private void showBadURCapVersion(boolean show) {
        this.badURCapVersion.setVisible(show);
        this.badBridgeSoftwareVersion.setVisible(!show);
        this.doubleBadVersion.setVisible(!show);
        this.versionCompatibility.setVisible(show);
    }

    private void showBadBridgeSoftwareVersion(boolean show) {
        this.badURCapVersion.setVisible(!show);
        this.badBridgeSoftwareVersion.setVisible(show);
        this.doubleBadVersion.setVisible(!show);
        this.versionCompatibility.setVisible(show);
    }

    private void showDoubleBadVersion(boolean show) {
        this.badURCapVersion.setVisible(!show);
        this.badBridgeSoftwareVersion.setVisible(!show);
        this.doubleBadVersion.setVisible(show);
        this.versionCompatibility.setVisible(show);
    }

    private void showToolConnectionUnknown() {
        this.toolConnectionImage.setIcon(this.connectionUnknownIcon);
        this.toolDetails.setVisible(false);
        this.toolNeedsFirmwareUpdatePanel.setVisible(false);
    }

    private void showToolDisconnected() {
        this.toolConnectionImage.setIcon(this.connectionNotOKIcon);
        this.toolDetails.setVisible(false);
        this.toolNeedsFirmwareUpdatePanel.setVisible(false);
    }

    void showToolConnected(@NotNull ToolInfo toolInfo) {
        this.toolConnectionImage.setIcon(this.connectionOKIcon);
        this.toolSerialNumber.setText(toolInfo.serialNumber().toString());
        this.toolSoftwareVersion.setText(toolInfo.softwareVersion().toString());
        this.toolNeedsFirmwareUpdatePanel.setVisible(toolInfo.needsFirmwareUpdate());
        this.toolDetails.setVisible(true);
    }

    void updateOnlineBridges(@NotNull ArrayList<DiscoveredBridge> bridges) {
        this.bridgeSelector.runWithoutFiringActionsEvents(() -> {
            this.bridgeSelector.removeAllItems();
            bridges.forEach(this.bridgeSelector::addItem);
        });
    }
}

