/*
 * Decompiled with CFR 0.152.
 */
package com.spin.bridge_communication.proxy;

import com.spin.bridge_communication.URCapInterfaceProvider;
import com.spin.bridge_communication.discovery.BridgeDiscovery;
import com.spin.bridge_communication.proxy.BridgeProxy;
import com.spin.bridge_communication.proxy.BridgeProxyFactory;
import com.spin.bridge_communication.proxy.BridgeProxyImpl;
import com.spin.bridge_communication.proxy.factory.ConnectionFactory;
import com.spin.bridge_communication.proxy.factory.DigitalOutputProvider;
import com.spin.bridge_communication.proxy.state_machine.ConnectionStateMachine;
import com.spin.bridge_communication.proxy.xmlrpc_client.XmlRpcBridgeClient;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.domain.io.DigitalIO;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class BridgeProxyFactoryImpl
implements BridgeProxyFactory {
    @NotNull
    private final ConnectionFactory connectionFactory;

    public BridgeProxyFactoryImpl(@NotNull ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    @NotNull
    public BridgeProxy createProxy(@NotNull InstallationAPIProvider installationAPIProvider, @NotNull URCapInterfaceProvider urCapInterfaceProvider) {
        SimpleValueFactory valueFactory = installationAPIProvider.getInstallationAPI().getValueFactoryProvider().getSimpleValueFactory();
        XmlRpcBridgeClient bridgeClient = new XmlRpcBridgeClient(8088, valueFactory);
        DigitalOutputProvider outputProvider = this.createOutputProvider(installationAPIProvider);
        ConnectionStateMachine stateMachine = this.connectionFactory.createStateMachine(bridgeClient, urCapInterfaceProvider, outputProvider);
        BridgeDiscovery bridgeDiscovery = new BridgeDiscovery(urCapInterfaceProvider);
        return new BridgeProxyImpl(bridgeClient, stateMachine, bridgeDiscovery);
    }

    @NotNull
    private DigitalOutputProvider createOutputProvider(@NotNull InstallationAPIProvider apiProvider) {
        Collection digitalIOs = apiProvider.getInstallationAPI().getIOModel().getIOs(DigitalIO.class);
        final DigitalIO heartbeatIO = digitalIOs.stream().filter(io -> io.getDefaultName().equals("config_out[6]")).findFirst().orElseThrow(() -> new IllegalStateException("config_out[6] does not exist"));
        final DigitalIO freedriveButtonIO = digitalIOs.stream().filter(io -> io.getDefaultName().equals("config_out[7]")).findFirst().orElseThrow(() -> new IllegalStateException("config_out[7] does not exist"));
        final DigitalIO frontButtonIO = digitalIOs.stream().filter(io -> io.getDefaultName().equals("config_out[5]")).findFirst().orElseThrow(() -> new IllegalStateException("config_out[5] does not exist"));
        return new DigitalOutputProvider(){

            @Override
            @NotNull
            public DigitalIO getHeartbeatOutput() {
                return heartbeatIO;
            }

            @Override
            @NotNull
            public DigitalIO getFreedriveButtonOutput() {
                return freedriveButtonIO;
            }

            @Override
            @NotNull
            public DigitalIO getFrontButtonOutput() {
                return frontButtonIO;
            }
        };
    }
}

