/*
 * Decompiled with CFR 0.152.
 */
package com.spin.ui.component.keypad;

import com.spin.i18n.TextResource;
import com.spin.ui.component.keypad.UnitKeypad;
import com.spin.ui.component.keypad.UnitRangeValidator;
import com.spin.ui.component.keypad.UnitValidatorText;
import com.spin.ui.unit.UnitConverter;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import org.jetbrains.annotations.NotNull;

public class UnitKeypadFactory {
    @NotNull
    private final KeyboardInputFactory keyboardInputFactory;
    @NotNull
    private final UnitConverter unitConverter;
    @NotNull
    private final TextResource textResource;

    public UnitKeypadFactory(@NotNull KeyboardInputFactory keyboardInputFactory, @NotNull UnitConverter unitConverter, @NotNull TextResource textResource) {
        this.keyboardInputFactory = keyboardInputFactory;
        this.unitConverter = unitConverter;
        this.textResource = textResource;
    }

    @NotNull
    public <Unit> UnitKeypad<Integer, Unit> createPositiveIntegerKeypad(@NotNull Class<Unit> unitClass) {
        return new UnitKeypad<Integer, Unit>(this.keyboardInputFactory.createPositiveIntegerKeypadInput(), this.unitConverter, Integer.class, unitClass);
    }

    @NotNull
    public <Unit> UnitKeypad<Integer, Unit> createIntegerKeypad(@NotNull Class<Unit> unitClass) {
        return new UnitKeypad<Integer, Unit>(this.keyboardInputFactory.createIntegerKeypadInput(), this.unitConverter, Integer.class, unitClass);
    }

    @NotNull
    public <Unit> UnitKeypad<Double, Unit> createPositiveDoubleKeypad(@NotNull Class<Unit> unitClass) {
        return new UnitKeypad<Double, Unit>(this.keyboardInputFactory.createPositiveDoubleKeypadInput(), this.unitConverter, Double.class, unitClass);
    }

    @NotNull
    public <Unit> UnitKeypad<Double, Unit> createDoubleKeypad(@NotNull Class<Unit> unitClass) {
        return new UnitKeypad<Double, Unit>(this.keyboardInputFactory.createDoubleKeypadInput(), this.unitConverter, Double.class, unitClass);
    }

    @NotNull
    public <Unit> UnitRangeValidator<Integer, Unit> createIntegerRangeValidator(@NotNull Class<Unit> unitClass, @NotNull Unit minValue, @NotNull Unit maxValue) {
        String errorMessage = this.textResource.load(UnitValidatorText.HELP_TEXT);
        return new UnitRangeValidator<Integer, Unit>(this.unitConverter, minValue, maxValue, errorMessage, Integer.class, unitClass);
    }

    @NotNull
    public <Unit> UnitRangeValidator<Double, Unit> createDoubleRangeValidator(@NotNull Class<Unit> unitClass, @NotNull Unit minValue, @NotNull Unit maxValue) {
        String errorMessage = this.textResource.load(UnitValidatorText.HELP_TEXT);
        return new UnitRangeValidator<Double, Unit>(this.unitConverter, minValue, maxValue, errorMessage, Double.class, unitClass);
    }
}

