/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.util;

import com.spin.urcap.impl.localization.LanguagePack;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;

public class SWVersion {
    static int MIN_POSSIBLE_E_SERIES_VERSION_MAJOR = 5;
    static final int MIN_POSSIBLE_E_SERIES_VERSION_MINOR = 0;
    static final int MIN_MAJOR_E_SERIES_VERSION = 5;
    static final int MIN_MINOR_E_SERIES_VERSION = 9;
    final int majorVersion;
    final int minorVersion;

    public SWVersion(ViewAPIProvider apiProvider) {
        this.majorVersion = apiProvider.getSystemAPI().getSoftwareVersion().getMajorVersion();
        this.minorVersion = apiProvider.getSystemAPI().getSoftwareVersion().getMinorVersion();
    }

    public SWVersion(InstallationAPIProvider apiProvider) {
        this.majorVersion = apiProvider.getSystemAPI().getSoftwareVersion().getMajorVersion();
        this.minorVersion = apiProvider.getSystemAPI().getSoftwareVersion().getMinorVersion();
    }

    public String getVersionInfoText() {
        String infoText;
        SWVersionType swVersionType = this.getSWVersionType();
        switch (swVersionType) {
            case UNSUPPORTED_ROBOT: {
                infoText = LanguagePack.getTextResource().badSWVersion0() + "\n" + LanguagePack.getTextResource().badSWVersion2() + " " + this.getMinimumVersion();
                break;
            }
            case E_SERIES_NOT_OK: {
                infoText = LanguagePack.getTextResource().badSWVersion1() + "\n" + LanguagePack.getTextResource().badSWVersion2() + " " + this.getMinimumVersion() + "\n" + LanguagePack.getTextResource().badSWVersion3();
                break;
            }
            default: {
                infoText = "Error retrieving robot version!";
            }
        }
        return infoText;
    }

    public boolean check() {
        return this.getSWVersionType() == SWVersionType.E_SERIES_OK;
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion;
    }

    private SWVersionType getSWVersionType() {
        if (this.majorVersion < MIN_POSSIBLE_E_SERIES_VERSION_MAJOR || this.minorVersion < 0) {
            return SWVersionType.UNSUPPORTED_ROBOT;
        }
        if (this.majorVersion < 5) {
            return SWVersionType.E_SERIES_NOT_OK;
        }
        if (this.minorVersion < 9 && this.majorVersion == 5) {
            return SWVersionType.E_SERIES_NOT_OK;
        }
        return SWVersionType.E_SERIES_OK;
    }

    private String getMinimumVersion() {
        return "5.9";
    }

    private static enum SWVersionType {
        E_SERIES_OK,
        E_SERIES_NOT_OK,
        UNSUPPORTED_ROBOT;

    }
}

