/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.localization;

import com.spin.urcap.impl.localization.CommandNamesResource;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.localization.UnitsResource;
import com.ur.urcap.api.domain.system.localization.Localization;
import java.util.Locale;

public class LanguagePack {
    public static final Locale rootLanguageLocale = Locale.ENGLISH;
    private static TextResource textResource;
    private final Localization localization;
    private CommandNamesResource commandNamesResource;
    private UnitsResource unitsResource;

    public LanguagePack(Localization localization) {
        this.localization = localization;
        this.createTextResource(localization.getLocale());
        this.createCommandNamesResource(localization.getLocaleForProgrammingLanguage());
        this.createUnitsResource(localization.getLocale());
    }

    public static TextResource getTextResource() {
        return textResource;
    }

    public Localization getLocalization() {
        return this.localization;
    }

    public CommandNamesResource getCommandNamesResource() {
        return this.commandNamesResource;
    }

    public UnitsResource getUnitsResource() {
        return this.unitsResource;
    }

    private void createTextResource(Locale locale) {
        textResource = new TextResource(locale);
    }

    private void createCommandNamesResource(Locale locale) {
        this.commandNamesResource = new CommandNamesResource(locale);
    }

    private void createUnitsResource(Locale locale) {
        this.unitsResource = new UnitsResource(locale);
    }
}

