/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.daemons.communicator;

import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.Length;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScriptTypeConverter {
    final PoseFactory poseFactory;
    private final String className = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);

    ScriptTypeConverter(PoseFactory poseFactory) {
        this.poseFactory = poseFactory;
    }

    public String booleanToScript(Boolean boolInput) {
        URBoolean bool = new URBoolean(boolInput);
        return bool.toString();
    }

    public String integerToScript(Integer integerInput) {
        return integerInput.toString();
    }

    public String doubleToScript(Double doubleInput) {
        return doubleInput.toString();
    }

    public String poseToScript(Pose poseInput) {
        return poseInput.toString();
    }

    public String listToScript(List<Object> listInput) {
        return listInput.toString();
    }

    public Integer scriptToInteger(String scriptInteger) {
        return Integer.parseInt(scriptInteger);
    }

    public Double scriptToDouble(String scriptDouble) {
        return Double.parseDouble(scriptDouble);
    }

    public Pose scriptToPose(String scriptPose) {
        List<String> strList = this.scriptToStringList(scriptPose);
        ArrayList<Double> p = new ArrayList<Double>();
        for (String s : strList) {
            p.add(Double.parseDouble(s));
        }
        return this.poseFactory.createPose(((Double)p.get(0)).doubleValue(), ((Double)p.get(1)).doubleValue(), ((Double)p.get(2)).doubleValue(), ((Double)p.get(3)).doubleValue(), ((Double)p.get(4)).doubleValue(), ((Double)p.get(5)).doubleValue(), Length.Unit.M, Angle.Unit.RAD);
    }

    public Boolean scriptToBoolean(String scriptBoolean) {
        return URBoolean.parseURBoolean(scriptBoolean);
    }

    private List<String> scriptToStringList(String scriptList) {
        scriptList = scriptList.replace("p", "").replace("[", "").replace("]", "");
        return Arrays.asList(scriptList.split("\\s*,\\s*"));
    }

    public List<Boolean> scriptToBooleanList(String scriptList) {
        List<String> items = this.scriptToStringList(scriptList);
        ArrayList<Boolean> returnValue = new ArrayList<Boolean>();
        for (String item : items) {
            returnValue.add(URBoolean.parseURBoolean(item));
        }
        return returnValue;
    }

    public List<Integer> scriptToIntegerList(String scriptList) {
        List<String> items = this.scriptToStringList(scriptList);
        ArrayList<Integer> returnValue = new ArrayList<Integer>();
        for (String item : items) {
            returnValue.add(Integer.parseInt(item));
        }
        return returnValue;
    }

    public List<Double> scriptToDoubleList(String scriptList) {
        List<String> items = this.scriptToStringList(scriptList);
        ArrayList<Double> returnValue = new ArrayList<Double>();
        for (String item : items) {
            returnValue.add(Double.parseDouble(item));
        }
        return returnValue;
    }

    static class URBoolean {
        final Boolean instance;

        public URBoolean(Boolean booleanInput) {
            this.instance = booleanInput;
        }

        static Boolean parseURBoolean(String str) {
            return Boolean.parseBoolean(str.toLowerCase());
        }

        public String toString() {
            String returnValue = this.instance != false ? "True" : "False";
            return returnValue;
        }
    }
}

