/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.util.soft_safety;

import com.spin.urcap.impl.util.Compare;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

public class SoftSafety {
    private static boolean isInitialized;
    private boolean safetyEnabled = true;
    private static final boolean DEFAULT_SAFETY_ENABLED = true;
    private Force safetyForce = null;
    private static final double DEFAULT_SAFETY_FORCE_N = 10.0;
    private static Force defaultSafetyForce;
    private static final double MIN_SAFETY_FORCE_N = 10.0;
    private static Force minSafetyForce;
    private static final double MAX_SAFETY_FORCE_N = 40.0;
    private static Force maxSafetyForce;

    public static void init(SimpleValueFactory valueFactory) {
        defaultSafetyForce = valueFactory.createForce(10.0, Force.Unit.N);
        minSafetyForce = valueFactory.createForce(10.0, Force.Unit.N);
        maxSafetyForce = valueFactory.createForce(40.0, Force.Unit.N);
        isInitialized = true;
    }

    public static SoftSafety softSafetyFactory() {
        assert (isInitialized);
        SoftSafety softSafety = new SoftSafety();
        softSafety.safetyEnabled = true;
        softSafety.safetyForce = defaultSafetyForce;
        return softSafety;
    }

    public static boolean safetyForceIsValid(@NotNull Force force) {
        return Compare.epsilonLessThanOrEquals(minSafetyForce, force) && Compare.epsilonLessThanOrEquals(force, maxSafetyForce);
    }

    public boolean isSafetyEnabled() {
        return this.safetyEnabled;
    }

    public void setSafetyEnabled(boolean safetyEnabled) {
        this.safetyEnabled = safetyEnabled;
    }

    public Force getSafetyForce() {
        return this.safetyForce;
    }

    public void setSafetyForce(Force safetyForce) {
        this.safetyForce = safetyForce;
    }

    public static Force getMinSafetyForce() {
        return minSafetyForce;
    }

    public static Force getMaxSafetyForce() {
        return maxSafetyForce;
    }
}

