/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes;

import com.spin.urcap.impl.localization.CommandNamesResource;
import com.spin.urcap.impl.localization.LanguagePack;
import com.spin.urcap.impl.localization.TextResource;
import com.spin.urcap.impl.localization.UnitsResource;
import com.spin.urcap.impl.program_nodes.PlaceBitProgramNodeView;
import com.spin.urcap.impl.util.PopupTool;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.domain.system.localization.UnitType;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputCallback;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardNumberInput;
import java.util.Objects;
import javax.swing.ImageIcon;

public class PlaceBitProgramNodeContribution
implements ProgramNodeContribution {
    private static final String KEY_FORCE_IN_TCP_Z = "KEY_FORCE_IN_TCP_Z";
    private static final String KEY_ENABLE_SAFETY = "KEY_ENABLE_SAFETY";
    private static final String KEY_APPROACH_OFFSET = "KEY_APPROACH_OFFSET";
    private static final String KEY_VELOCITY = "KEY_VELOCITY";
    private static final String KEY_SELECTED_BIT = "KEY_SELECTED_BIT";
    private static final double MIN_OFFSET = 55.0;
    private static final double MM_TO_M = 0.001;
    private final ProgramAPI programAPI;
    private final PlaceBitProgramNodeView view;
    private final LanguagePack languagePack;
    private final KeyboardInputFactory keyboardInputFactory;
    private final KeyboardInputFactory keyboardFactoryPickBitForceInTCPZ;
    private final DataModel model;
    private final Localization localization;

    PlaceBitProgramNodeContribution(ProgramAPIProvider apiProvider, PlaceBitProgramNodeView view, DataModel model) {
        this.programAPI = apiProvider.getProgramAPI();
        this.model = model;
        this.view = view;
        this.keyboardInputFactory = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.keyboardFactoryPickBitForceInTCPZ = apiProvider.getUserInterfaceAPI().getUserInteraction().getKeyboardInputFactory();
        this.languagePack = new LanguagePack(apiProvider.getSystemAPI().getSystemSettings().getLocalization());
        this.localization = apiProvider.getSystemAPI().getSystemSettings().getLocalization();
    }

    public void openView() {
        this.view.updateBitHolderComboBox(this.getLastSelectedBit());
        this.view.setSelectBitLabel(this.getTextResource().selectBitProgramPickBit());
        this.view.setL1OffsetLabel(this.getTextResource().offsetProgramPickBit());
        this.view.setVelocityLabel(this.getTextResource().velocityProgramPickBit());
        if (this.getUnitType().equals((Object)UnitType.METRIC)) {
            this.view.setL1OffsetUnitLabel(this.getUnitResource().UNIT_mm());
            this.view.setVelocityUnitLabel(this.getUnitResource().UNIT_velocityM());
        } else {
            this.view.setL1OffsetUnitLabel(this.getUnitResource().UNIT_in());
            this.view.setVelocityUnitLabel(this.getUnitResource().UNIT_velocityI());
        }
        this.view.setApproachOffset(this.model.get(KEY_APPROACH_OFFSET, 55.0));
        this.view.setVelocity(this.model.get(KEY_VELOCITY, 200.0));
        this.view.setForceInTCPZUnitLabel(this.getUnitResource().UNIT_Newton());
        this.view.setForceInTCPZLabel(this.getTextResource().loadScrewForce());
        this.model.set(KEY_FORCE_IN_TCP_Z, "10");
        this.view.setForceInTCPZ(this.model.get(KEY_FORCE_IN_TCP_Z, "10"));
        this.view.setComponentsVisible(false);
    }

    public void closeView() {
        this.view.setPanelsVisible();
    }

    public UnitType getUnitType() {
        return this.localization.getUnitType();
    }

    private UnitsResource getUnitResource() {
        return this.languagePack.getUnitsResource();
    }

    private TextResource getTextResource() {
        return LanguagePack.getTextResource();
    }

    private CommandNamesResource getCommandNamesResource() {
        return this.languagePack.getCommandNamesResource();
    }

    public String getTitle() {
        return this.getCommandNamesResource().nodeNamePlaceBit() + ": " + this.getLastSelectedBit();
    }

    public boolean isDefined() {
        return this.model.isSet(KEY_SELECTED_BIT);
    }

    public void generateScript(ScriptWriter scriptWriter) {
        Object[] features;
        boolean bitFeatureDefined = false;
        for (Object feature : features = this.programAPI.getFeatureModel().getGeomFeatures().toArray()) {
            if (!feature.toString().equals("SpinBitChanger")) continue;
            bitFeatureDefined = true;
        }
        if (bitFeatureDefined) {
            scriptWriter.appendLine("spin_place_bit(" + Integer.parseInt(this.getLastSelectedBit()) + "," + this.model.get(KEY_APPROACH_OFFSET, 55.0) * 0.001 + "," + this.model.get(KEY_VELOCITY, 200.0) * 0.001 + "," + "SpinBitChanger" + "," + this.getForceInZAxis() + "," + (this.view.getEnableSafety() ? "True" : "False") + ")");
        } else {
            scriptWriter.appendLine("popup(" + PopupTool.quote(this.getTextResource().bitChangerStationNotDefined()) + ", error=True, blocking=True)");
        }
    }

    public KeyboardNumberInput<Double> getKeyboardApproachOffset() {
        KeyboardNumberInput keyboard = this.keyboardInputFactory.createDoubleKeypadInput();
        keyboard.setInitialValue((Object)this.model.get(KEY_APPROACH_OFFSET, 55.0));
        return keyboard;
    }

    public KeyboardInputCallback<Double> getCallbackApproachOffset() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                if (value < 55.0) {
                    PopupTool.showDialogWarning(PlaceBitProgramNodeContribution.this.getTextResource().changeBitOffsetWarning(), PlaceBitProgramNodeContribution.this.getTextResource().changeBitOffsetWarningTitle(), new ImageIcon(Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/com/spin/urcap/icons/UR_e-Series_1.0/warning_icon_small.png"))));
                    PlaceBitProgramNodeContribution.this.model.set(PlaceBitProgramNodeContribution.KEY_APPROACH_OFFSET, 55.0);
                    PlaceBitProgramNodeContribution.this.view.setApproachOffset(55.0);
                } else {
                    PlaceBitProgramNodeContribution.this.model.set(PlaceBitProgramNodeContribution.KEY_APPROACH_OFFSET, value.doubleValue());
                    PlaceBitProgramNodeContribution.this.view.setApproachOffset(value);
                }
            }
        };
    }

    public KeyboardNumberInput<Double> getKeyboardVelocity() {
        KeyboardNumberInput keyboard = this.keyboardInputFactory.createPositiveDoubleKeypadInput();
        keyboard.setInitialValue((Object)this.model.get(KEY_VELOCITY, 200.0));
        return keyboard;
    }

    public KeyboardInputCallback<Double> getCallbackVelocity() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                PlaceBitProgramNodeContribution.this.model.set(PlaceBitProgramNodeContribution.KEY_VELOCITY, value.doubleValue());
                PlaceBitProgramNodeContribution.this.view.setVelocity(value);
            }
        };
    }

    public KeyboardNumberInput<Double> getKeyboardForForceInTCPZ() {
        KeyboardNumberInput keyboardInput = this.keyboardFactoryPickBitForceInTCPZ.createDoubleKeypadInput();
        keyboardInput.setInitialValue((Object)(this.view.getForceInTCPZ().isEmpty() ? 0.0 : Double.parseDouble(this.view.getForceInTCPZ())));
        return keyboardInput;
    }

    public KeyboardInputCallback<Double> getCallbackForForceInTCPZ() {
        return new KeyboardInputCallback<Double>(){

            public void onOk(Double value) {
                PlaceBitProgramNodeContribution.this.view.setForceInTCPZ(Double.toString(value));
                PlaceBitProgramNodeContribution.this.model.set(PlaceBitProgramNodeContribution.KEY_FORCE_IN_TCP_Z, value.doubleValue());
            }
        };
    }

    public void safetySettingsChanged(final boolean safety_enabled) {
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                PlaceBitProgramNodeContribution.this.model.set(PlaceBitProgramNodeContribution.KEY_ENABLE_SAFETY, safety_enabled);
            }
        });
    }

    public String getLastSelectedBit() {
        return this.model.get(KEY_SELECTED_BIT, this.getTextResource().changeBitSelectBit());
    }

    public void setLastSelectedBit(final String fixture) {
        this.programAPI.getUndoRedoManager().recordChanges(new UndoableChanges(){

            public void executeChanges() {
                PlaceBitProgramNodeContribution.this.model.set(PlaceBitProgramNodeContribution.KEY_SELECTED_BIT, fixture);
            }
        });
    }

    private double getForceInZAxis() {
        return this.model.get(KEY_FORCE_IN_TCP_Z, 0.0);
    }
}

