/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.installation_node.feeder;

import com.spin.urcap.impl.installation_node.feeder.Feeder;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.UUID;
import java.util.Vector;
import org.jetbrains.annotations.Nullable;

public class FeederData {
    private final DataModel model;

    public FeederData(DataModel model) {
        this.model = model;
    }

    public void saveFeeder(Feeder feeder) {
        String prefix = FeederKey.FEEDER.name() + feeder.getId();
        try {
            this.model.set(prefix + InstanceKey.NAME.name(), feeder.getName());
            this.model.set(prefix + InstanceKey.OFFSET.name(), feeder.getOffset());
            this.model.set(prefix + InstanceKey.RETRIES_COUNT.name(), feeder.getRetriesCount());
            this.model.set(prefix + InstanceKey.SCREW_LENGTH.name(), feeder.getScrewLength());
            this.model.set(prefix + InstanceKey.SPEED.name(), feeder.getSpeed());
            this.model.set(prefix + InstanceKey.POSE.name(), feeder.getPose());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.out.println("Key is null or an empty string");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void saveLastSelectedFeeder(Feeder feeder) {
        this.model.set(FeederKey.FEEDER.name() + FeederKey.LAST_SELECTED_FEEDER.name(), feeder.getId().toString());
    }

    public Feeder loadLastSelectedFeeder() {
        return this.loadFeeder(this.loadLastSelectedFeederId());
    }

    public String loadLastSelectedFeederId() {
        return this.model.get(FeederKey.FEEDER.name() + FeederKey.LAST_SELECTED_FEEDER.name(), "");
    }

    @Nullable
    public Feeder loadFeeder(String id) {
        if (!this.feederExist(id)) {
            return null;
        }
        Feeder feeder = new Feeder(UUID.fromString(id));
        String preamble = FeederKey.FEEDER.name() + id;
        feeder.setName(this.model.get(preamble + InstanceKey.NAME.name(), ""));
        feeder.setOffset(this.model.get(preamble + InstanceKey.OFFSET.name(), (Length)null));
        feeder.setRetriesCount(this.model.get(preamble + InstanceKey.RETRIES_COUNT.name(), 0));
        feeder.setScrewLength(this.model.get(preamble + InstanceKey.SCREW_LENGTH.name(), (Length)null));
        feeder.setSpeed(this.model.get(preamble + InstanceKey.SPEED.name(), (Speed)null));
        feeder.setPose(this.model.get(preamble + InstanceKey.POSE.name(), (Pose)null));
        return feeder;
    }

    public void removeFeeder(UUID id) {
        try {
            String preamble = FeederKey.FEEDER.name() + id;
            this.model.remove(preamble + InstanceKey.NAME.name());
            this.model.remove(preamble + InstanceKey.OFFSET.name());
            this.model.remove(preamble + InstanceKey.RETRIES_COUNT.name());
            this.model.remove(preamble + InstanceKey.SCREW_LENGTH.name());
            this.model.remove(preamble + InstanceKey.SPEED.name());
            this.model.remove(preamble + InstanceKey.POSE.name());
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void removeFeeder(Feeder feeder) {
        this.removeFeeder(feeder.getId());
    }

    public Vector<Feeder> loadFeeders() {
        String[] feederIds = this.loadFeederIds();
        Vector<Feeder> feeders = new Vector<Feeder>(feederIds.length + 5);
        for (String id : feederIds) {
            feeders.add(this.loadFeeder(id));
        }
        return feeders;
    }

    private String[] loadFeederIds() {
        return this.model.get(FeederKey.FEEDER.name() + FeederKey.FEEDER_LIST.name(), new String[0]);
    }

    private boolean feederExist(String id) {
        String[] ids;
        for (String idi : ids = this.loadFeederIds()) {
            if (!id.equals(idi)) continue;
            return true;
        }
        return false;
    }

    public void saveFeederIds(Vector<Feeder> feeders) {
        String[] feederIds = new String[feeders.size()];
        for (int i = 0; i < feeders.size(); ++i) {
            feederIds[i] = feeders.elementAt(i).getId().toString();
        }
        this.model.set(FeederKey.FEEDER.name() + FeederKey.FEEDER_LIST.name(), feederIds);
    }

    private static enum InstanceKey {
        NAME,
        RETRIES_COUNT,
        OFFSET,
        SCREW_LENGTH,
        SPEED,
        POSE;

    }

    private static enum FeederKey {
        FEEDER,
        FEEDER_LIST,
        LAST_SELECTED_FEEDER;

    }
}

