/*
 * Decompiled with CFR 0.152.
 */
package com.spin.urcap.impl.program_nodes;

import com.spin.urcap.impl.localization.CommandNamesResource;
import com.spin.urcap.impl.localization.TextResource;
import com.ur.urcap.api.contribution.driver.general.script.ScriptCodeGenerator;
import com.ur.urcap.api.contribution.driver.general.tcp.TCPConfiguration;
import com.ur.urcap.api.contribution.driver.general.userinput.CustomUserInputConfiguration;
import com.ur.urcap.api.contribution.driver.screwdriver.ContributionConfiguration;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverAPIProvider;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverConfiguration;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverContribution;
import com.ur.urcap.api.contribution.driver.screwdriver.ScrewdriverParameters;
import com.ur.urcap.api.contribution.driver.screwdriver.SystemConfiguration;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.DriveScrewNotOKParameters;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.DriveScrewOKParameters;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.ScrewdriverFeedbackCapabilities;
import com.ur.urcap.api.contribution.driver.screwdriver.capability.ScrewdriverReadyParameters;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.Locale;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AdvancedScrewdriver
implements ScrewdriverContribution {
    private TextResource textResource;

    public String getTitle(Locale locale) {
        this.textResource = new TextResource(locale);
        return new CommandNamesResource(locale).nodeNameAdvancedScrewdriver();
    }

    public void configureContribution(ContributionConfiguration configuration) {
        configuration.setLogo((Icon)new ImageIcon(Objects.requireNonNull(this.getClass().getResource("/com/spin/urcap/icons/SR_logo.png"))));
    }

    public void configureScrewdriver(ScrewdriverConfiguration screwdriverConfiguration, ScrewdriverAPIProvider screwdriverAPIProvider) {
        screwdriverConfiguration.getScrewdriverCapabilities().registerOperationTypeCapability();
        ScrewdriverFeedbackCapabilities feedbackCapabilities = screwdriverConfiguration.getScrewdriverFeedbackCapabilities();
        feedbackCapabilities.registerScrewdriverReadyCapability(this.createScrewdriverReadyScriptCodeGenerator());
        feedbackCapabilities.registerDriveScrewOKCapability(this.createDriveScrewOKScriptCodeGenerator());
        feedbackCapabilities.registerDriveScrewNotOKCapability(this.createDriveScrewNotOKScriptCodeGenerator());
    }

    private ScriptCodeGenerator<ScrewdriverReadyParameters> createScrewdriverReadyScriptCodeGenerator() {
        return new ScriptCodeGenerator<ScrewdriverReadyParameters>(){

            public void generateScript(ScriptWriter scriptWriter, ScrewdriverReadyParameters screwdriverReadyParameters) {
                scriptWriter.appendLine("return rpc.ModbusHandler.ping() == True");
            }
        };
    }

    private ScriptCodeGenerator<DriveScrewOKParameters> createDriveScrewOKScriptCodeGenerator() {
        return new ScriptCodeGenerator<DriveScrewOKParameters>(){

            public void generateScript(ScriptWriter scriptWriter, DriveScrewOKParameters driveScrewOKParameters) {
                scriptWriter.appendLine("return rpc.ModbusHandler.getBridgeScrewProcessState() == 2");
            }
        };
    }

    private ScriptCodeGenerator<DriveScrewNotOKParameters> createDriveScrewNotOKScriptCodeGenerator() {
        return new ScriptCodeGenerator<DriveScrewNotOKParameters>(){

            public void generateScript(ScriptWriter scriptWriter, DriveScrewNotOKParameters driveScrewNotOKParameters) {
                scriptWriter.appendLine("return isScrewNotOkay()");
            }
        };
    }

    public void configureInstallation(CustomUserInputConfiguration configurationUIBuilder, SystemConfiguration systemConfiguration, TCPConfiguration tcpConfiguration, ScrewdriverAPIProvider apiProvider) {
        configurationUIBuilder.setDescriptionText(this.textResource.advancedScrewdriverDescriptionText());
        configurationUIBuilder.addText(this.textResource.advancedScrewdriverText(), "");
    }

    public void generatePreambleScript(ScriptWriter scriptWriter) {
    }

    public void generateStartScrewdriverScript(ScriptWriter scriptWriter, ScrewdriverParameters parameters) {
        scriptWriter.appendLine("rpc.ModbusHandler.setScrewProgramCommand(1, screwProgramId, robotStartOffset)");
        scriptWriter.appendLine("if(typeId != 1):");
        scriptWriter.appendLine("\tspin_motor_wait_for_ramp()");
        scriptWriter.appendLine("end");
    }

    public void generateStopScrewdriverScript(ScriptWriter scriptWriter, ScrewdriverParameters parameters) {
        scriptWriter.appendLine("rpc.ModbusHandler.setScrewProgramCommand(0, 0, 0.0)");
        scriptWriter.appendLine("handleErrorsAfterStop()");
    }
}

