/*
 * Decompiled with CFR 0.152.
 */
package com.spin.domain;

import com.spin.ui.image.SpinIcon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiInstall {
    @Nullable
    private static Character character;
    @Nullable
    private static Boolean disableToolButtons;

    public static boolean isMultiInstall() {
        return character != null;
    }

    @NotNull
    public static String prefix() {
        if (character == null) {
            return "";
        }
        return character + "-";
    }

    @NotNull
    public static String urscriptPrefix() {
        if (character == null) {
            return "spin_";
        }
        return character + "_";
    }

    @NotNull
    public static String postfix() {
        if (character == null) {
            return "";
        }
        return "-" + character;
    }

    @NotNull
    public static ImageIcon toolbarIcon() {
        if (character == null) {
            return SpinIcon.LOGO_TOOLBAR.load();
        }
        if (character.charValue() == 'A') {
            return SpinIcon.LOGO_TOOLBAR_A.load();
        }
        if (character.charValue() == 'B') {
            return SpinIcon.LOGO_TOOLBAR_B.load();
        }
        if (character.charValue() == 'C') {
            return SpinIcon.LOGO_TOOLBAR_C.load();
        }
        if (character.charValue() == 'D') {
            return SpinIcon.LOGO_TOOLBAR_D.load();
        }
        if (character.charValue() == 'E') {
            return SpinIcon.LOGO_TOOLBAR_E.load();
        }
        if (character.charValue() == 'F') {
            return SpinIcon.LOGO_TOOLBAR_F.load();
        }
        return SpinIcon.LOGO_TOOLBAR.load();
    }

    public static void parseCharacter(@Nullable String oneChar) {
        if (oneChar == null || oneChar.isEmpty()) {
            character = null;
            return;
        }
        if (oneChar.length() > 1) {
            throw new IllegalArgumentException("Only one character allowed.");
        }
        character = Character.valueOf(oneChar.charAt(0));
    }

    public static void parseDisableToolButtons(@Nullable String disableToolButtonsString) {
        if (disableToolButtonsString == null) {
            return;
        }
        if (disableToolButtonsString.equals("true")) {
            disableToolButtons = true;
        } else if (disableToolButtonsString.equals("false")) {
            disableToolButtons = false;
        } else {
            throw new IllegalArgumentException("Allowed values for disableToolButtons are [true, false]");
        }
    }

    public static boolean disableToolButtons() {
        if (disableToolButtons == null) {
            return false;
        }
        return disableToolButtons;
    }
}

