/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.safe_approach;

import com.spin.util.api.ExtendedProgramAPIProvider;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import com.ur.urcap.api.domain.variable.VariableModel;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class SafeApproachData {
    @NotNull
    private final DataModel model;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final VariableModel variableModel;
    @NotNull
    private final String safeApproachVariableName = "safe_approach_p";
    @NotNull
    private final String safeApproachCoverDist = "ss_cover_dist";

    SafeApproachData(@NotNull DataModel model, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.model = model;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.variableModel = apiProvider.getProgramAPIProvider().getProgramAPI().getVariableModel();
    }

    @NotNull
    public Variable safeApproachTargetPose() {
        SpinLog.print("data: finding safe");
        return this.findExistingSafeApproachTargetPose().orElseGet(this::createSafeApproachTargetPose);
    }

    @NotNull
    public Variable safeApproachCoverDist() {
        SpinLog.print("data: finding cover dist");
        return this.findExistingSafeApproachCoverDist().orElseGet(this::createSafeApproachCoverDist);
    }

    @NotNull
    private Optional<Variable> findExistingSafeApproachTargetPose() {
        return this.variableModel.get(variable -> variable.getDisplayName().equals("safe_approach_p")).stream().findFirst();
    }

    @NotNull
    private Optional<Variable> findExistingSafeApproachCoverDist() {
        return this.variableModel.get(variable -> variable.getDisplayName().equals("ss_cover_dist")).stream().findFirst();
    }

    @NotNull
    private Variable createSafeApproachTargetPose() {
        try {
            return this.variableModel.getVariableFactory().createGlobalVariable("safe_approach_p");
        }
        catch (VariableException e) {
            SpinLog.print("Unable to create safe_approach_p variable");
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private Variable createSafeApproachCoverDist() {
        try {
            return this.variableModel.getVariableFactory().createGlobalVariable("ss_cover_dist");
        }
        catch (VariableException e) {
            SpinLog.print("Unable to create ss_cover_dist variable");
            throw new RuntimeException(e);
        }
    }
}

