/*
 * Decompiled with CFR 0.152.
 */
package com.spin.util.api;

import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayInterface;
import com.spin.core.program_node.hidden_nodes.move_away.MoveAwayService;
import com.spin.core.program_node.safe_approach.SafeApproachInterface;
import com.spin.core.program_node.safe_approach.SafeApproachService;
import com.spin.core.program_node.tool_action.ToolActionInterface;
import com.spin.core.program_node.tool_action.ToolActionService;
import com.spin.core.program_node.tool_action.ToolFunction;
import com.spin.domain.MultiInstall;
import com.spin.util.logging.SpinLog;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.AssignmentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.CommentNode;
import com.ur.urcap.api.domain.program.nodes.builtin.DirectionNode;
import com.ur.urcap.api.domain.program.nodes.builtin.FolderNode;
import com.ur.urcap.api.domain.program.nodes.builtin.HaltNode;
import com.ur.urcap.api.domain.program.nodes.builtin.MoveNode;
import com.ur.urcap.api.domain.program.nodes.builtin.PopupNode;
import com.ur.urcap.api.domain.program.nodes.builtin.UntilNode;
import com.ur.urcap.api.domain.program.nodes.builtin.WaypointNode;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.assignmentnode.AssignmentNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionAxis;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.directionnode.DirectionNodeConfigBuilder;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveJMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveLMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.builder.MoveNodeConfigBuilders;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.DistanceUntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.UntilNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.UntilNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.BlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.URCapProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;
import com.ur.urcap.api.domain.validation.ErrorHandler;
import com.ur.urcap.api.domain.value.expression.Expression;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.expression.InvalidExpressionException;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.domain.variable.VariableException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class NodeFactory {
    public static void addMoveAwayNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull SimpleValueFactory valueFactory) throws TreeStructureException {
        URCapProgramNode moveNode = programNodeFactory.createURCapProgramNode(MoveAwayService.class);
        rootNode.addChild((ProgramNode)moveNode);
        ((MoveAwayInterface)moveNode.getAs(MoveAwayInterface.class)).setMoveDistance(valueFactory.createLength(50.0, Length.Unit.MM));
    }

    public static void addSafetyShieldCoverBitNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException {
        URCapProgramNode toolActionNode = programNodeFactory.createURCapProgramNode(ToolActionService.class);
        rootNode.addChild((ProgramNode)toolActionNode);
        ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
    }

    public static void addAssignmentNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull Variable variable, @NotNull Expression expression) throws TreeStructureException {
        rootNode.addChild((ProgramNode)NodeFactory.createAssignmentNode(programNodeFactory, variable, expression));
    }

    public static AssignmentNode createAssignmentNode(@NotNull ProgramNodeFactory programNodeFactory, @NotNull Variable variable, @NotNull Expression expression) {
        AssignmentNode assignmentNode = programNodeFactory.createAssignmentNode();
        AssignmentNodeConfigFactory assignmentNodeConfigFactory = assignmentNode.getConfigFactory();
        assignmentNode.setConfig((AssignmentNodeConfig)assignmentNodeConfigFactory.createExpressionConfig(variable, expression));
        return assignmentNode;
    }

    public static void addCommentNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull String comment) throws TreeStructureException {
        CommentNode commentNode = programNodeFactory.createCommentNode();
        commentNode.setComment(comment);
        rootNode.addChild((ProgramNode)commentNode);
    }

    public static TreeNode addFolderNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory, @NotNull String folderName) throws TreeStructureException {
        FolderNode folderNode = programNodeFactory.createFolderNode();
        folderNode.setName(folderName);
        folderNode.setSubtreeHidden(true);
        return rootNode.addChild((ProgramNode)folderNode);
    }

    @NotNull
    private static Expression createExpression(ExpressionBuilder expressionBuilder) {
        try {
            expressionBuilder.append("pose_trans(program_start_p, p[0,0,-0.05,0,0,0])");
            return expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addSafeApproachFolder(@NotNull TreeNode rootNode, @NotNull ProgramAPI programAPI, @NotNull Variable aboveProgramStartPoseVariable) throws TreeStructureException {
        ProgramNodeFactory programNodeFactory = programAPI.getProgramModel().getProgramNodeFactory();
        FolderNode folderNode = programNodeFactory.createFolderNode();
        folderNode.setName("Safe Approach");
        TreeNode folderTreeNode = rootNode.addChild((ProgramNode)folderNode);
        ExpressionBuilder expressionBuilder = programAPI.getValueFactoryProvider().createExpressionBuilder();
        NodeFactory.addAssignmentNode(folderTreeNode, programNodeFactory, aboveProgramStartPoseVariable, NodeFactory.createExpression(expressionBuilder));
        MoveNode moveJNode = NodeFactory.createMoveJNode(programNodeFactory);
        TreeNode moveJTreeNode = folderTreeNode.addChild((ProgramNode)moveJNode);
        WaypointNode waypointNode = NodeFactory.createWaypointNode(aboveProgramStartPoseVariable, programAPI);
        moveJTreeNode.addChild((ProgramNode)waypointNode);
        URCapProgramNode safeApproachNode = programNodeFactory.createURCapProgramNode(SafeApproachService.class);
        TreeNode safeApproachTree = folderTreeNode.addChild((ProgramNode)safeApproachNode);
        SafeApproachInterface tmp = (SafeApproachInterface)safeApproachNode.getAs(SafeApproachInterface.class);
        Variable safeApproachTarget = tmp.getSafeApproachTarget();
        expressionBuilder = programAPI.getValueFactoryProvider().createExpressionBuilder();
        AssignmentNode assignmentNode = NodeFactory.createAssignmentNode(programNodeFactory, safeApproachTarget, NodeFactory.createSafeExpression(expressionBuilder));
        folderTreeNode.insertChildBefore(safeApproachTree, (ProgramNode)assignmentNode);
        Variable safeApproachCoverDist = tmp.getSafeApproachCoverDist();
        expressionBuilder = programAPI.getValueFactoryProvider().createExpressionBuilder();
        AssignmentNode coverDistNode = NodeFactory.createAssignmentNode(programNodeFactory, safeApproachCoverDist, NodeFactory.createspin_init_ss_position(expressionBuilder));
        folderTreeNode.insertChildBefore(safeApproachTree, (ProgramNode)coverDistNode);
        folderNode.setSubtreeHidden(true);
    }

    @NotNull
    private static Expression createSafeExpression(ExpressionBuilder expressionBuilder) {
        try {
            expressionBuilder.append("program_start_p");
            return expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static Expression createspin_init_ss_position(ExpressionBuilder expressionBuilder) {
        try {
            expressionBuilder.append("spin_init_ss_position()");
            return expressionBuilder.build();
        }
        catch (InvalidExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addMoveAwayFolder(@NotNull TreeNode treeNode, @NotNull ProgramAPI programAPI) throws TreeStructureException {
        ProgramNodeFactory programNodeFactory = programAPI.getProgramModel().getProgramNodeFactory();
        FolderNode folderNode = programNodeFactory.createFolderNode();
        folderNode.setName("Move Away");
        TreeNode folderTreeNode = treeNode.addChild((ProgramNode)folderNode);
        MoveNode moveLNode = NodeFactory.createMoveLNode(programNodeFactory);
        TreeNode moveLTreeNode = folderTreeNode.addChild((ProgramNode)moveLNode);
        DirectionNode directionNode = NodeFactory.createDirectionNode(programAPI);
        TreeNode directionTreeNode = moveLTreeNode.addChild((ProgramNode)directionNode);
        TreeNode untilDistanceTreeNode = (TreeNode)directionTreeNode.getChildren().get(0);
        UntilNode untilNode = (UntilNode)untilDistanceTreeNode.getProgramNode();
        NodeFactory.configureUntilNode(untilNode, programAPI);
        URCapProgramNode toolActionNode = programNodeFactory.createURCapProgramNode(ToolActionService.class);
        folderTreeNode.addChild((ProgramNode)toolActionNode);
        ((ToolActionInterface)toolActionNode.getAs(ToolActionInterface.class)).selectFunction(ToolFunction.SAFETY_SHIELD_COVER_BIT);
        folderNode.setSubtreeHidden(true);
    }

    public static void addPopupNode(@NotNull TreeNode treeNode, @NotNull ProgramAPI programAPI, @NotNull String message, @NotNull PopupNode.Type type) throws TreeStructureException {
        ProgramNodeFactory programNodeFactory = programAPI.getProgramModel().getProgramNodeFactory();
        PopupNode popupNode = programNodeFactory.createPopupNode();
        popupNode.setType(type);
        popupNode.setMessage(message);
        treeNode.addChild((ProgramNode)popupNode);
    }

    public static void configureUntilNode(UntilNode untilDistance, ProgramAPI programAPI) {
        SimpleValueFactory simpleValueFactory = programAPI.getValueFactoryProvider().getSimpleValueFactory();
        UntilNodeConfigFactory configFactory = untilDistance.getConfigFactory();
        Length distanceLength = simpleValueFactory.createLength(50.0, Length.Unit.MM);
        com.ur.urcap.api.domain.program.nodes.builtin.configurations.untilnode.BlendParameters blendParameters = configFactory.createNoBlendParameters();
        DistanceUntilNodeConfig config = configFactory.createDistanceConfig(distanceLength, ErrorHandler.AUTO_CORRECT, blendParameters);
        untilDistance.setConfig((UntilNodeConfig)config);
    }

    public static DirectionNode createDirectionNode(ProgramAPI programAPI) {
        ProgramNodeFactory programNodeFactory = programAPI.getProgramModel().getProgramNodeFactory();
        FeatureModel featureModel = programAPI.getFeatureModel();
        DirectionNode directionNode = programNodeFactory.createDirectionNode();
        DirectionNodeConfigBuilder builder = directionNode.createConfigBuilder();
        DirectionNodeConfig config = builder.setFeature((Feature)featureModel.getToolFeature()).setDirection(DirectionAxis.Axis.Z_MINUS).build();
        directionNode.setConfig(config);
        return directionNode;
    }

    public static WaypointNode createWaypointNode(Variable variable, ProgramAPI programAPI) {
        ProgramNodeFactory programNodeFactory = programAPI.getProgramModel().getProgramNodeFactory();
        WaypointNode waypointNode = programNodeFactory.createWaypointNode();
        WaypointNodeConfigFactory waypointNodeConfigFactory = waypointNode.getConfigFactory();
        BlendParameters blendParameters = waypointNodeConfigFactory.createNoBlendParameters();
        waypointNode.setConfig((WaypointNodeConfig)waypointNode.getConfigFactory().createVariablePositionConfig(variable, blendParameters, waypointNode.getConfigFactory().createSharedMotionParameters()));
        return waypointNode;
    }

    public static MoveNode createMoveJNode(ProgramNodeFactory programNodeFactory) {
        MoveNode moveJNode = programNodeFactory.createMoveNodeNoTemplate();
        MoveNodeConfigBuilders moveJNodeConfigBuilders = moveJNode.getConfigBuilders();
        MoveJMoveNodeConfig moveJMoveNodeConfig = moveJNodeConfigBuilders.createMoveJConfigBuilder().build();
        moveJNode.setConfig((MoveNodeConfig)moveJMoveNodeConfig);
        return moveJNode;
    }

    public static MoveNode createMoveLNode(ProgramNodeFactory programNodeFactory) {
        MoveNode moveNode = programNodeFactory.createMoveNodeNoTemplate();
        MoveNodeConfigBuilders moveNodeConfigBuilders = moveNode.getConfigBuilders();
        MoveLMoveNodeConfig moveLMoveNodeConfig = moveNodeConfigBuilders.createMoveLConfigBuilder().build();
        moveNode.setConfig((MoveNodeConfig)moveLMoveNodeConfig);
        return moveNode;
    }

    public static void addHaltNode(@NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException {
        HaltNode haltNode = programNodeFactory.createHaltNode();
        rootNode.addChild((ProgramNode)haltNode);
    }

    public static void addAbortFlagAssignmentNode(@NotNull ProgramAPI programAPI, @NotNull TreeNode rootNode, @NotNull ProgramNodeFactory programNodeFactory) throws TreeStructureException, InvalidExpressionException {
        Variable abort_flag = NodeFactory.get_abort_flag(programAPI);
        ExpressionBuilder expressionBuilder = programAPI.getValueFactoryProvider().createExpressionBuilder();
        Expression trueExpression = expressionBuilder.append("True").build();
        NodeFactory.addAssignmentNode(rootNode, programNodeFactory, abort_flag, trueExpression);
    }

    public static Variable get_spin_message(ProgramAPI programAPI) {
        Collection variables = programAPI.getVariableModel().getAll();
        if (variables.isEmpty()) {
            SpinLog.print("No variables found");
        } else {
            SpinLog.print("Variables found:");
            for (Variable variable : variables) {
                SpinLog.print("  " + variable.getDisplayName());
                if (!variable.getDisplayName().equals("spin_message")) continue;
                return variable;
            }
        }
        SpinLog.print("Creating variable spin_message");
        try {
            return programAPI.getVariableModel().getVariableFactory().createGlobalVariable("spin_message");
        }
        catch (VariableException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Variable get_abort_flag(ProgramAPI programAPI) {
        Collection variables = programAPI.getVariableModel().getAll();
        if (variables.isEmpty()) {
            SpinLog.print("No variables found");
        } else {
            SpinLog.print("Variables found:");
            for (Variable variable : variables) {
                SpinLog.print("  " + variable.getDisplayName());
                if (!variable.getDisplayName().equals("abort")) continue;
                return variable;
            }
        }
        SpinLog.print("Creating variable abort");
        try {
            return programAPI.getVariableModel().getVariableFactory().createGlobalVariable("abort");
        }
        catch (VariableException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Variable get_spin_target(ProgramAPI programAPI) {
        Collection variables = programAPI.getVariableModel().getAll();
        if (variables.isEmpty()) {
            SpinLog.print("No variables found");
        } else {
            Object temp = null;
            SpinLog.print("Variables found:");
            for (Variable variable : variables) {
                SpinLog.print("  " + variable.getDisplayName());
                if (!variable.getDisplayName().equals(MultiInstall.urscriptPrefix() + "target")) continue;
                return variable;
            }
        }
        SpinLog.print("Creating variable  " + MultiInstall.urscriptPrefix() + "target");
        try {
            return programAPI.getVariableModel().getVariableFactory().createGlobalVariable(MultiInstall.urscriptPrefix() + "target");
        }
        catch (VariableException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

