/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw;

import com.spin.core.program_node.load_screw.LoadScrewContribution;
import com.spin.core.program_node.load_screw.LoadScrewText;
import com.spin.domain.ScrewFeeder;
import com.spin.ui.component.AbstractMessageBox;
import com.spin.ui.component.CheckBox;
import com.spin.ui.component.ComboBox;
import com.spin.ui.component.ImagePanel;
import com.spin.ui.component.Label;
import com.spin.ui.component.MessageBoxSmall;
import com.spin.ui.image.SpinIcon;
import com.spin.ui.image.SpinImage;
import com.spin.ui.image.UR_Icon;
import com.spin.ui.layout.UR_MigLayout;
import com.spin.util.api.ExtendedViewAPIProvider;
import com.spin.util.i18n.TextResource;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadScrewView
implements SwingProgramNodeView<LoadScrewContribution> {
    @NotNull
    private final ImagePanel logo;
    @NotNull
    private final ImagePanel loadScrew;
    @NotNull
    private final ComboBox<ScrewFeeder> screwFeederSelector;
    @NotNull
    private final Label setupMissingLabel;
    @NotNull
    private final CheckBox useForceCheckBox;
    @NotNull
    private final CheckBox approachCheckBox;
    @NotNull
    private final MessageBoxSmall approachWarning;
    @NotNull
    private final CheckBox departureCheckBox;
    @NotNull
    private final MessageBoxSmall departureWarning;

    LoadScrewView(ExtendedViewAPIProvider extendedViewAPIProvider) {
        TextResource textResource = extendedViewAPIProvider.getTextResource();
        this.logo = new ImagePanel(SpinIcon.LOGO_PROGRAM_NODE.load());
        this.loadScrew = new ImagePanel(SpinImage.LOAD_SCREW.load());
        this.setupMissingLabel = new Label(textResource.load(LoadScrewText.MISSING_SETUP), UR_Icon.WARNING_SMALL.load(), 2);
        this.screwFeederSelector = new ComboBox();
        this.screwFeederSelector.setDefaultText(textResource.load(LoadScrewText.NONE));
        this.useForceCheckBox = new CheckBox(textResource.load(LoadScrewText.USE_FORCE));
        this.approachCheckBox = new CheckBox(textResource.load(LoadScrewText.APPROACH_ENABLE));
        this.approachWarning = new MessageBoxSmall(textResource.load(LoadScrewText.APPROACH_WARNING), AbstractMessageBox.Type.WARNING);
        this.departureCheckBox = new CheckBox(textResource.load(LoadScrewText.DEPART_ENABLE));
        this.departureWarning = new MessageBoxSmall(textResource.load(LoadScrewText.DEPART_WARNING), AbstractMessageBox.Type.WARNING);
    }

    public void buildUI(JPanel panel, ContributionProvider<LoadScrewContribution> provider) {
        panel.setLayout((LayoutManager)UR_MigLayout.equalColumns(12, 10, "[top][][][][][]push[]"));
        panel.add(this.screwFeederSelector, "cell 0 0 6 0, grow");
        panel.add((Component)this.loadScrew, "cell 7 0 5 6, grow");
        panel.add((Component)this.setupMissingLabel, "cell 0 1 6 1");
        panel.add((Component)this.logo, "cell 0 6 3 1");
        this.registerListeners(provider);
    }

    private void registerListeners(@NotNull ContributionProvider<LoadScrewContribution> provider) {
        ActionListener comboBoxListener = e -> {
            ScrewFeeder selectedFeeder = (ScrewFeeder)this.screwFeederSelector.getSelectedItem();
            if (selectedFeeder != null) {
                ((LoadScrewContribution)provider.get()).selectScrewFeeder(selectedFeeder);
            }
        };
        this.screwFeederSelector.addActionListener(comboBoxListener);
        this.useForceCheckBox.addActionListener(event -> ((LoadScrewContribution)provider.get()).setUseForce(this.useForceCheckBox.isSelected()));
        this.approachCheckBox.addActionListener(event -> {
            boolean enabled = this.approachCheckBox.isSelected();
            ((LoadScrewContribution)provider.get()).setApproachEnabled(enabled);
            this.approachWarning.setVisible(!enabled);
        });
        this.departureCheckBox.addActionListener(event -> {
            boolean enabled = this.departureCheckBox.isSelected();
            ((LoadScrewContribution)provider.get()).setDepartEnabled(enabled);
            this.departureWarning.setVisible(!enabled);
        });
    }

    public void setScrewFeeders(@NotNull Set<ScrewFeeder> screwFeeders) {
        this.screwFeederSelector.runWithoutFiringActionsEvents(() -> {
            this.screwFeederSelector.removeAllItems();
            screwFeeders.stream().sorted(Comparator.comparing(feeder -> feeder.name().toLowerCase()).thenComparing(ScrewFeeder::name)).forEach(this.screwFeederSelector::addItem);
        });
        this.setupMissingLabel.setVisible(screwFeeders.isEmpty());
    }

    void setApproachEnabled(boolean enabled) {
        this.approachCheckBox.setSelected(enabled);
        this.approachWarning.setVisible(!enabled);
    }

    void setDepartEnabled(boolean enabled) {
        this.departureCheckBox.setSelected(enabled);
        this.departureWarning.setVisible(!enabled);
    }

    void selectedScrewFeeder(@Nullable ScrewFeeder screwFeeder) {
        this.screwFeederSelector.setSelectedItem(screwFeeder);
    }

    void setUseForce(boolean useForce) {
        this.useForceCheckBox.setSelected(useForce);
    }
}

