/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.program_node.load_screw.pick_screw;

import com.spin.core.installation_node.InstallationContribution;
import com.spin.util.api.ExtendedProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import org.jetbrains.annotations.NotNull;

public class PickScrewData {
    @NotNull
    private final DataModel dataModel;
    @NotNull
    private final UndoRedoManager undoRedoManager;
    @NotNull
    private final InstallationContribution installationContribution;

    PickScrewData(@NotNull DataModel dataModel, @NotNull ExtendedProgramAPIProvider apiProvider) {
        this.dataModel = dataModel;
        this.undoRedoManager = apiProvider.getProgramAPIProvider().getProgramAPI().getUndoRedoManager();
        this.installationContribution = (InstallationContribution)apiProvider.getProgramAPIProvider().getProgramAPI().getInstallationNode(InstallationContribution.class);
    }

    boolean isValidConfiguration() {
        return true;
    }

    int motorSpeedRPM() {
        return this.dataModel.get("motorSpeedRPM", 60);
    }

    void setMotorSpeedRPM(int motorSpeedRPM) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("motorSpeedRPM", motorSpeedRPM));
    }

    int robotSpeedmms() {
        return this.dataModel.get("robotSpeedmms", 10);
    }

    void setRobotSpeedmms(int robotSpeedmms) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("robotSpeedmms", robotSpeedmms));
    }

    double waitTimesec() {
        return this.dataModel.get("pickWaitTimesec", 0.0);
    }

    void setWaitTimesec(double waitTimesec) {
        this.undoRedoManager.recordChanges(() -> this.dataModel.set("pickWaitTimesec", waitTimesec));
    }

    @NotNull
    Integer minAllowedRPM() {
        return -750;
    }

    @NotNull
    Integer maxAllowedRPM() {
        return 750;
    }
}

