/*
 * Decompiled with CFR 0.152.
 */
package com.spin.core.installation_node.bridge_tool;

import com.ur.urcap.api.domain.data.DataModel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public class BridgeAndToolData {
    @NotNull
    private static final String defaultBridgeIP = "192.168.37.1";
    @NotNull
    private final DataModel model;

    public BridgeAndToolData(@NotNull DataModel model) {
        this.model = model;
    }

    @NotNull
    InetAddress bridgeIP() {
        return this.loadBridgeIP();
    }

    void storeBridgeIP(@NotNull InetAddress address) {
        this.model.set("ip", address.getHostAddress());
    }

    @NotNull
    private InetAddress loadBridgeIP() {
        try {
            String ipString = this.model.get("ip", defaultBridgeIP);
            return InetAddress.getByName(ipString);
        }
        catch (UnknownHostException e) {
            assert (false) : "Invalid IP address loaded. This should not be possible";
            throw new IllegalStateException(e);
        }
    }
}

